package parser.state;

import java.util.Collection;

import collection.Tree;
import datatypes.CallGraphInfo;
import datatypes.FlatProfileInfo;

public class FlatProfileState extends VNProfState {
	private FlatProfileInfo info;
	@Override
	protected void init(String line) {
		// TODO Auto-generated method stub
		info = new FlatProfileInfo();
		String[] tokens = line.split("[ \t]+");
		
		info.setTime(Double.parseDouble(tokens[1]));
		info.setCSeconds(Double.parseDouble(tokens[2]));
		info.setSSeconds(Double.parseDouble(tokens[3]));
		info.setCalls(Integer.parseInt(tokens[4]));
		info.setSelfCall(Double.parseDouble(tokens[5]));
		info.setTotalCall(Double.parseDouble(tokens[6]));
		info.setName(tokens[7]);
	}

	@Override
	protected VNProfState parseLine(String line) {
		// TODO Auto-generated method stub
		/*
		String[] tokens = line.split("[ \t]+");
		boolean check = true;
		
		for(int i=1; i<4; i++){
			if(!(check = tokens[i].matches("[0-9]+.[0-9]+"))){
				break;
			}
		}
		*/
		if(!line.equals("")){
			return new FlatProfileState();
		}
		else{
			return new CommentState();
		}
	}

	@Override
	protected void process(Collection<FlatProfileInfo> flatProfile,
			Collection<Tree<CallGraphInfo>> callGraph) {
		// TODO Auto-generated method stub
		flatProfile.add(info);
	}

	@Override
	protected void process() {
		// TODO Auto-generated method stub
		
	}

}
