package parser.state;

import java.util.Collection;
import java.util.Iterator;

import collection.Tree;
import datatypes.CallGraphInfo;
import datatypes.FlatProfileInfo;

public class CallerState extends CallerListSuperClass{
	private Tree<CallGraphInfo> infoTree;
	private CallerListSuperClass next;
	
	@Override
	protected void init(String line) {
		// TODO Auto-generated method stub
		CallGraphInfo info = new CallGraphInfo();

		String[] tokens = line.split("[ \t]+");
		
		if(!tokens[1].matches("[0-9]+.[0-9]+")){
			VNProfState.disable = true;
		}
		else{
			info.setSelf(Double.parseDouble(tokens[1]));
			info.setChildren(Double.parseDouble(tokens[2]));
			info.setName(tokens[4]);
			info.setIndex(Integer.parseInt(tokens[5].replaceAll("[^0-9]", "")));
	
			infoTree = new Tree<CallGraphInfo>(info);
		}
	}

	@Override
	protected VNProfState parseLine(String line) {
		// TODO Auto-generated method stub
		String[] tokens = line.split("[ \t]+");
		if(tokens[0].equals("")/*matches("[0-9]+.[0-9]")*/){
			next = new CallerState();
		}
		else{
			next = new SelfState();
		}
		return next;
	}

	@Override
	protected void process(Collection<FlatProfileInfo> flatProfile,
			Collection<Tree<CallGraphInfo>> callGraph) {
		// TODO Auto-generated method stub

		boolean check = true;
		Iterator<Tree<CallGraphInfo>> it = callGraph.iterator();
		
		while(it.hasNext()){
			Tree<CallGraphInfo> temp;
			if((temp = it.next()).getData().getIndex() == this.infoTree.getData().getIndex()){
				check = false;
				infoTree = temp;
				break;
			}
		}
		
		if(check){
			callGraph.add(infoTree);
		}
	}

	@Override
	protected void process() {
		// TODO Auto-generated method stub
		callerList.add(infoTree);
		next.setCallerList(callerList);
	}

}
