package parser.state;

import java.util.Collection;
import java.util.Iterator;

import collection.Tree;
import datatypes.CallGraphInfo;
import datatypes.FlatProfileInfo;

public class CalleeState extends VNProfState {
	private Tree<CallGraphInfo> caller;
	
	private Tree<CallGraphInfo> infoTree;

	private boolean nextType = false;
	private CalleeState nextState;
	
	
	protected void init(String line) {
		// TODO Auto-generated method stub
		CallGraphInfo info = new CallGraphInfo();

		String[] tokens = line.split("[ \t]+");
		
		info.setSelf(Double.parseDouble(tokens[1]));
		info.setChildren(Double.parseDouble(tokens[2]));
		info.setName(tokens[4]);
		info.setIndex(Integer.parseInt(tokens[5].replaceAll("[^0-9]", "")));
		
		infoTree = new Tree<CallGraphInfo>(info);
	}

	
	protected VNProfState parseLine(String line) {
		
		String[] tokens = line.split("[ \t]+");
		if(tokens[0].equals("")/*matches("[0-9]+.[0-9]")*/){
			nextType = true;
			nextState = new CalleeState();
			return nextState;
		}
		else {
			return new LineState();
		}
		
		//TODO Auto-generated method stub
		
	}

	
	protected void process(Collection<FlatProfileInfo> flatProfile,
			Collection<Tree<CallGraphInfo>> callGraph) {
		// TODO Auto-generated method stub
		boolean check = true;
		Iterator<Tree<CallGraphInfo>> it = callGraph.iterator();
		
		while(it.hasNext()){
			Tree<CallGraphInfo> temp;
			if((temp = it.next()).getData().getIndex() == this.infoTree.getData().getIndex()){
				check = false;
				infoTree = temp;
				break;
			}
		}
		
		if(check){
			callGraph.add(infoTree);
		}
		
		check = true;
		caller.initRound();
		while(caller.hasNextSubNodes()){
			Tree<CallGraphInfo> subNode = caller.nextSubNode();
			if(subNode.getData().getIndex() == this.infoTree.getData().getIndex()){
				check = false;
				break;
			}
		}
		if(check){
			caller.add(infoTree);
		}
	}


	@Override
	protected void process() {
		// TODO Auto-generated method stub
		if(nextType){
			nextState.setCaller(caller);
		}
	}
	
	public void setCaller(Tree<CallGraphInfo> caller){
		this.caller = caller;
	}

}
