#include "stdafx.h"
#include "traywnd.h"


VOID CALLBACK OnShowWindow(HWND hwnd, WPARAM w, LPARAM)
{
	if(w == TRUE)
	{
		RECT	rcWorkArea;
		SystemParametersInfo(SPI_GETWORKAREA, 0, &rcWorkArea, FALSE);
		
		SetWindowPos(	hwnd, 
						HWND_TOPMOST, 
						rcWorkArea.right - 400, rcWorkArea.bottom - 300, 400, 300, 
						0																					);
	}
}

VOID CALLBACK OnPaint(HWND hwnd, WPARAM, LPARAM)
{
	HDC				hdc;
	PAINTSTRUCT		ps;
	HBITMAP			hBmp;
	HDC		hMemDC;
	HBITMAP	hOldBmp;
	BITMAP	bi;
		
	hdc = BeginPaint(hwnd, &ps);

	hBmp = (HBITMAP) GetProp(hwnd, "BITMAP");

    if(hBmp != NULL)
	{
		GetObject(hBmp, sizeof bi, &bi);

		hMemDC = CreateCompatibleDC(hdc);
		hOldBmp = (HBITMAP) SelectObject(hMemDC, GetProp(hwnd, "BITMAP"));

		BitBlt(hdc, 0, 0, bi.bmWidth, bi.bmHeight, hMemDC, 0, 0, SRCCOPY);
	
		SelectObject(hMemDC, hOldBmp);
		DeleteDC(hMemDC);

		EndPaint(hwnd, &ps);
	}
}

LRESULT CALLBACK TrayWndMsgProc(HWND hwnd, UINT iMsg, WPARAM w, LPARAM l)
{
	LRESULT	lRet = 0;

	switch(iMsg)
	{
	case WM_CREATE:
		SetProp(hwnd, "BITMAP", 0);
		break;

	case WM_DESTROY:
		RemoveProp(hwnd, "BITMAP");
		break;

	case WM_SHOWWINDOW:
		OnShowWindow(hwnd, w, l);
		break;

	case WM_PAINT:
		OnPaint(hwnd, w, l);
		break;

	case WM_SETBITMAP:
		SetProp(hwnd, "BITMAP", (HANDLE) l);
		InvalidateRect(hwnd, NULL, FALSE);
		break;

	default:
		lRet = DefWindowProc(hwnd, iMsg, w, l);
		break;
	}

	return lRet;
}


VOID RegisterBaseWndClass(HINSTANCE hInst, PSTR szClassName, WNDPROC wProc)
{
	WNDCLASS	wcs;
	
	if(GetClassInfo(hInst, szClassName, &wcs) == 0)
	{
		wcs.cbClsExtra		= 0;
		wcs.cbWndExtra		= 0;
		wcs.hbrBackground	= (HBRUSH) COLOR_WINDOW;
		wcs.hCursor			= LoadCursor(NULL, IDC_ARROW);
		wcs.hIcon			= LoadIcon(NULL, IDI_APPLICATION);
		wcs.hInstance		= hInst;
		wcs.lpfnWndProc		= wProc;
		wcs.lpszClassName	= szClassName;
		wcs.lpszMenuName	= NULL;
		wcs.style			= 0;
		
		RegisterClass(&wcs);
	}
}

HWND CreateTrayWnd()
{
	RegisterBaseWndClass(GetModuleHandle(NULL), "TrayNotifyWnd", TrayWndMsgProc);

	return CreateWindowEx(WS_EX_TOOLWINDOW, "TrayNotifyWnd", "", WS_CLIPCHILDREN | WS_POPUP, 0, 0, 0, 0, NULL, NULL, GetModuleHandle(NULL), 0);
}