//
// File: Buffer.cpp
// Created by: Alexander Oster - tensor@ultima-iris.de
//
#include "stdafx.h"
#include "Buffer.h"
#include "Debug.h"
#include "Exception.h"
#include <iostream>
#include <stdlib.h>
#include <string.h>

using namespace std;

#ifdef _DEBUG
#define new DEBUG_NEW
#endif

BufferEntry::BufferEntry()
{
}

BufferEntry::~BufferEntry()
{
}

Buffer::Buffer()
{
  size = 0;
  bufferarray = NULL;
}

Buffer::~Buffer()
{
  if(bufferarray)
    Free();
}

int Buffer::GetSize(void)
{
  return size;
}

void Buffer::Create(int size)
{
  if(bufferarray)
    Free();
  this->size = size;
  bufferarray = (BufferEntry **) malloc(size * 4);
  memset(bufferarray, 0, size * 4);
}

void Buffer::Free(void)
{
  if(!bufferarray)
    return;
  Flush();

  free(bufferarray);
  bufferarray = NULL;
  size = 0;
}

void Buffer::Flush(void)
{
  if(!bufferarray)
    return;

  for (int index = 0; index < size; index++)
    if(bufferarray[index])
      delete(bufferarray[index]);

  memset(bufferarray, 0, size * 4);
}

void Buffer::Add(int index, BufferEntry * entry)
{
  if(!bufferarray) 
     THROWEXCEPTION ("NULL buffer array");

  if((index < 0) || (index >= size))      
     THROWEXCEPTION ("array bounds violation");


  if(bufferarray[index])
    delete bufferarray[index];

  bufferarray[index] = entry;
}

void Buffer::Delete(int index)
{
  Add(index, NULL);
}

BufferEntry *Buffer::Get(int index)
{
  if(!bufferarray) 
     THROWEXCEPTION ("NULL buffer array");

  if((index < 0) || (index >= size)) {
    return NULL;
  }

  return bufferarray[index];
}


