#pragma once

// CGrannyListView

class CGrannyViewerDoc;
class cGrannyModelTD;
class cGrannyModelAOS;

class CGrannyListView : public CTreeView
{
	DECLARE_DYNCREATE(CGrannyListView)

	// xy yy yy yy - x : type info, y : data
	UINT ISSET(UINT c)		{ return c & 0xC0000000; }
	UINT ISCHAR(UINT c)		{ return c & 0x80000000; }
	UINT ISANIM(UINT c)		{ return c & 0x40000000; }
	UINT SETCHAR(UINT c)	{ return c | 0x80000000; }
	UINT SETANIM(UINT c )	{ return c | 0x40000000; }
	UINT GETDATA(UINT c)	{ return c & 0x3FFFFFFF; }

	// equip item
	UINT GETASSIGN(UINT c)  { return c >> 16; }
	UINT GETID(UINT c)		{ return c & 0xFFFF; }
	UINT ISPART(UINT c)		{ return c & 0xC000; }

	CImageList m_imageList;

	HTREEITEM InsertModelTD(CTreeCtrl& tree, HTREEITEM htRoot, Uint32 id, cGrannyModelTD *model);
	HTREEITEM InsertModelAOS(CTreeCtrl& tree, HTREEITEM htRoot, Uint32 id, cGrannyModelAOS *model);
	HTREEITEM InsertEquipItem(CTreeCtrl& tree, HTREEITEM htRoot, Uint32 id, cGrannyModelTD *model);

	bool IsPlayerModelID(int id) { return id == 400 || id == 401; }
public:
	CGrannyListView();
	virtual ~CGrannyListView();

	CGrannyViewerDoc* GetDocument() const;

	// Ʈ õ  lParam ȯ
	UINT GetSelectedItemData();
	// Ʈ õ  ̸ ȯ
	CString GetSelectedItemName();

protected:
	DECLARE_MESSAGE_MAP()
public:
	virtual void OnInitialUpdate();
	afx_msg int OnCreate(LPCREATESTRUCT lpCreateStruct);
	afx_msg void OnNMDblclk(NMHDR *pNMHDR, LRESULT *pResult);
	afx_msg void OnNMClick(NMHDR *pNMHDR, LRESULT *pResult);
	afx_msg void OnTvnSelchanged(NMHDR *pNMHDR, LRESULT *pResult);
	afx_msg void OnNMRclick(NMHDR *pNMHDR, LRESULT *pResult);
};

#ifndef _DEBUG  // GrannyViewerView.cpp  
inline CGrannyViewerDoc* CGrannyListView::GetDocument() const
   { return reinterpret_cast<CGrannyViewerDoc*>(m_pDocument); }
#endif
