<?

class HKFPDF extends KFPDF
{
	var $B;
	var $I;
	var $U;
	var $HREF;
	var $fontList;
	var $issetfont;
	var $issetcolor;

	function HKFPDF( $orientation = 'P', $unit = 'mm', $format = 'A4' )
	{
		//Call parent constructor
		$this->KFPDF( $orientation, $unit, $format );
		//Initialization
		$this->B = 0;
		$this->I = 0;
		$this->U = 0;
		$this->HREF = '';

		$this->tableborder = 0;
		$this->tdbegin = false;
		$this->tdwidth = 0;
		$this->tdheight = 0;
		$this->tdalign = "L";
		$this->tdbgcolor = false;

		$this->oldx = 0;
		$this->oldy = 0;

		$this->fontlist = array("arial", "times", "courier", "helvetica", "symbol");
		$this->issetfont = false;
		$this->issetcolor = false;
	}

	function WriteHTML( $html )
	{
		global $ttpdfw_default_config;

		$html = strip_tags( $html, "<b><u><i><img><p><br><strong><em><font><tr><blockquote><hr><sup>" );
		$html = str_replace( "\n", '',$html ); //replace carriage returns by spaces
		$html = str_replace( "\t", '',$html ); //replace carriage returns by spaces
		$a = preg_split( '/<(.*)>/U', $html ,-1, PREG_SPLIT_DELIM_CAPTURE ); //explodes the string
		foreach( $a as $i => $e )
		{
			if( ($i % 2) == 0 )
			{
				//Text
				if( $this->HREF )
				{
					$this->PutLink( $this->HREF, $e );
				}
				elseif( $this->tdbegin )
				{
					if( (trim($e) != '') && ($e != "&nbsp;") )
					{
						$this->Cell( $this->tdwidth, $this->tdheight, $e, $this->tableborder, '', $this->tdalign, $this->tdbgcolor );
					}
					elseif( $e == "&nbsp;" )
					{
						$this->Cell( $this->tdwidth, $this->tdheight, '', $this->tableborder, '', $this->tdalign, $this->tdbgcolor);
					}
				}
				else
				{
					$this->Write( $ttpdfw_default_config['global_body_lineheight'], 
												stripslashes(unhtmlentities($e)) );
				}
			}
			else
			{
				//Tag
				if( $e{0} == '/' )
				{
					$this->CloseTag( strtoupper(substr($e, 1)) );
				}
				else
				{
					//Extract attributes
					$a2 = explode( ' ', $e );
					$tag = strtoupper( array_shift($a2) );
					$attr = array();
					foreach( $a2 as $v )
					{
						if( ereg('^([^=]*)=["\']?([^"\']*)["\']?$', $v, $a3) )
						{
							$attr[strtoupper($a3[1])] = $a3[2];
						}
						$this->OpenTag($tag, $attr);
					} // ~ foreach( $a2 as $v )
				} // ~ if( $e{0} == '/' )
			} // ~ if( ($i % 2) == 0 )
		} // ~ foreach( $a as $i => $e )
	} // ~ function WriteHTML( $html )

	function OpenTag( $tag, $attr )
	{
		global $ttpdfw_default_config;
		//Opening tag
		switch( $tag )
		{
			case 'SUP':
			{
				if( $attr['SUP'] != '' )
				{    
					//Set current font to: Bold, 6pt     
					$this->SetFont( '', '', 6 );
					//Start 125cm plus width of cell to the right of left margin         
					//Superscript "1" 
					$this->Cell( 2, 2, $attr['SUP'], 0, 0, 'L' );
				}
				break;
			}
			case 'TABLE': // TABLE-BEGIN
			{
				if( $attr['BORDER'] != '' )
				{
					$this->tableborder = $attr['BORDER'];
				}
				else
				{
					$this->tableborder = 0;
				}
				break;
			}
			case 'TR': //TR-BEGIN
			{
				break;
			}
			case 'TD': // TD-BEGIN
			{
				if( $attr['WIDTH'] != '' )
				{
					$this->tdwidth = ($attr['WIDTH'] / 4);
				}
				else
				{
					// SET to your own width if you need bigger fixed cells
					$this->tdwidth=40;
				}
				if( $attr['HEIGHT'] != '')
				{
					$this->tdheight = ($attr['HEIGHT'] / 6);
				}
				else
				{
					// SET to your own height if you need bigger fixed cells
					$this->tdheight = 6;
				}
				if( $attr['ALIGN'] != '' )
				{
					$align = $attr['ALIGN'];        
					if( $align == "LEFT" )
					{
						$this->tdalign = "L";
					}
					if( $align == "CENTER" )
					{
						$this->tdalign = "C";
					}
					if( $align == "RIGHT" )
					{
						$this->tdalign = "R";
					}
				} // ~ if( $attr['ALIGN'] != '' )
				else
				{
					// SET to your own
					$this->tdalign = "L";
				}
				if( $attr['BGCOLOR'] != '' )
				{
					$coul = hex2dec( $attr['BGCOLOR'] );
					$this->SetFillColor( $coul['R'], $coul['G'], $coul['B'] );
					$this->tdbgcolor = true;
				}
				$this->tdbegin = true;
				break;
			}
			case 'HR':
			{
				if( $attr['WIDTH'] != '' )
				{
					$Width = $attr['WIDTH'];
				}
				else
				{
					$Width = $this->w - $this->lMargin - $this->rMargin;
				}
				$x = $this->GetX();
				$y = $this->GetY();
				$this->SetLineWidth( 0.2 );
				$this->Line( $x, $y, $x + $Width, $y );
				$this->SetLineWidth( 0.2 );
				$this->Ln( 1 );
				break;
			}
			case 'STRONG':
			{
				$this->SetStyle( 'B', true );
				break;
			}
			case 'EM':
			{
				$this->SetStyle( 'I', true );
				break;
			}
			case 'B':
			case 'I':
			case 'U':
			{
				$this->SetStyle( $tag, true );
				break;
			}
			case 'A':
			{
				$this->HREF = $attr['HREF'];
				break;
			}
			case 'IMG':
			{
				if(  (isset($attr['SRC'])) 
					&& (isset($attr['WIDTH']) 
					|| (isset($attr['HEIGHT']))) )
				{
					if( !isset($attr['WIDTH']) )
					{
						$attr['WIDTH'] = 0;
					}
					if( !isset($attr['HEIGHT']) )
					{
						$attr['HEIGHT'] = 0;
					}
					/*
						 ̹ ũ⳪  Ŀ   ̹ θ  ķ  ֽϴ.  ̹ ¿ ̺ ϰ ִµ,  ¿ óϴ  δ ſ ϴ. ׷ ̹ ¿  ̹      ϰ ֽϴ. ̷ ؼ Ÿ  ̹ Ʒ ϵ   ĵ ʴ´ٴ ε, δ Ư F ó  ߽ϴ.    մµ, HTML ó ġ ʰ ̹ ؼ   ϴ [##  ϴ ̹ ±׸  ȹ ֽϴ.
						*/
					$x = ((210 - ($ttpdfw_default_config['global_left_margin'] + $ttpdfw_default_config['global_right_margin'])) 
										 - px2mm($attr['WIDTH'])) / 2 + $ttpdfw_default_config['global_left_margin'];
					$this->Image( $attr['SRC'], $x, $this->GetY(), px2mm($attr['WIDTH']), px2mm($attr['HEIGHT']) );
					$this->Ln( px2mm($attr['HEIGHT']) );
				}
				break;
			}
			//case 'TR':
			case 'BLOCKQUOTE':
			case 'BR':
			{
				$this->Ln( $ttpdfw_default_config['global_br_height'] );
				break;
			}
			case 'P':
			{
				$this->Ln( $ttpdfw_default_config['global_br_height'] );
				break;
			}
			case 'FONT':
			{
				if( isset($attr['COLOR']) && $attr['COLOR']!='')
				{
					$coul = hex2dec( $attr['COLOR'] );
					$this->SetTextColor( $coul['R'], $coul['G'], $coul['B'] );
					$this->issetcolor = true;
				}
				if(  isset($attr['FACE']) 
					&& in_array(strtolower($attr['FACE']), $this->fontlist) )
				{
					$this->SetFont( strtolower($attr['FACE']) );
					$this->issetfont = true;
				}
				if(	 isset($attr['FACE']) 
					&& in_array(strtolower($attr['FACE']), $this->fontlist) and isset($attr['SIZE']) 
					&& $attr['SIZE']!='' )
				{
					$this->SetFont(strtolower($attr['FACE']),'',$attr['SIZE']);
					$this->issetfont=true;
				}
				break;
			} // ~ case 'FONT': 
		} // ~ switch( $tag )
	} // ~ function OpenTag( $tag, $attr )

	function CloseTag( $tag )
	{
		// Closing tag
		if( $tag == 'SUP' )
		{

		}

		if( $tag == 'TD' ) // TD-END
		{
			$this->tdbegin = false;
			$this->tdwidth = 0;
			$this->tdheight = 0;
			$this->tdalign = "L";
			$this->tdbgcolor = false;
		}
		if( $tag == 'TR' ) // TR-END
		{
			$this->Ln();
		}
		if( $tag == 'TABLE' ) // TABLE-END
		{
			//$this->Ln();
			$this->tableborder=0;
		}
		if( $tag == 'STRONG' )
		{
			$tag = 'B';
		}
		if( $tag == 'EM' )
		{
			$tag = 'I';
		}
		if( ($tag == 'B') || ($tag == 'I') || ($tag == 'U') )
		{
			$this->SetStyle( $tag, false );
		}
		if( $tag == 'A' )
		{
			$this->HREF = '';
		}
		if( $tag == 'FONT' )
		{
			if( $this->issetcolor == true )
			{
				$this->SetTextColor( 0 );
			}
			if( $this->issetfont )
			{
				$this->SetFont('arial');
				$this->issetfont=false;
			}
		} // ~ if( $tag == 'FONT' )
	} // ~ function CloseTag( $tag )

	function SetStyle( $tag, $enable )
	{
		//Modify style and select corresponding font
		$this->$tag += ( $enable ? 1 : -1 );
		$style = '';
		foreach( array('B', 'I', 'U') as $s )
		{
			if( $this->$s > 0 )
			{
				$style .= $s;
			}
		}
		$this->SetFont( '', $style );
	}

	function PutLink( $URL, $txt )
	{
		//Put a hyperlink
		global $body_lineheight, $body_fontsize;

		$this->SetFont( 'UHC', '', $body_fontsize );
		$this->SetTextColor( 0, 0, 255 );
		$this->SetStyle( 'U', true );
		$this->Write( $body_lineheight, $txt, $URL );
		$this->SetStyle( 'U', false );
		$this->SetTextColor( 0 );

	}

}
?>