#ifndef _I386_DESC_H_
#define _I386_DESC_H_

#include <arch/ldt.h>

/*
 * The layout of the GDT under Linux:
 *
 *   0 - null
 *   1 - not used
 *   2 - kernel code segment
 *   3 - kernel data segment
 *   4 - user code segment                  <-- new cacheline 
 *   5 - user data segment
 *   6 - not used
 *   7 - not used
 *
 * The TSS+LDT descriptors are spread out a bit so that every CPU
 * has an exclusive cacheline for the per-CPU TSS and LDT:
 *
 *  12 - CPU#0 TSS                          <-- new cacheline 
 *  13 - CPU#0 LDT
 *  14 - not used 
 *  15 - not used 
 *  16 - CPU#1 TSS                          <-- new cacheline 
 *  17 - CPU#1 LDT
 *  18 - not used 
 *  19 - not used 
 *  ... NR_CPUS per-CPU TSS+LDT's if on SMP
 *
 * Entry into gdt where to find first TSS.
 */
#define __FIRST_TSS_ENTRY 8
#define __FIRST_LDT_ENTRY (__FIRST_TSS_ENTRY+1)

#define __TSS(n) (((n)<<2) + __FIRST_TSS_ENTRY)
#define __LDT(n) (((n)<<2) + __FIRST_LDT_ENTRY)

#ifndef __ASSEMBLY__

struct desc_struct {
	unsigned long a, b;
};

#endif /* !__ASSEMBLY__ */

#endif
