/*
 * $Id: init.c,v 1.1 2002/09/09 05:51:51 halite Exp $
 *
 * Created by halite on 2002.08.29
 */

#include <toykernel/kernel.h>
#include <toykernel/init.h>
#include <toykernel/mm.h>
#include <arch/pgtable.h>
#include <arch/processor.h>

extern char _text, _etext, _edata, _end;

/*
 * Sets all page directory, page table, page table entry.
 */
static void __init paging_init(void)
{
	unsigned long	vaddr, end;
	pgd_t			*pgd, *pgd_base;
	pmd_t			*pmd;
	pte_t			*pte, *pte_base;
	int				i, j, k;

	end = (unsigned long)__va(max_low_pfn * PAGE_SIZE);

	pgd_base = swapper_pg_dir;
	i        = __pgd_offset(PAGE_OFFSET);
	pgd      = pgd_base + i;

	for (; i < PTRS_PER_PGD; pgd++, i++)
	{
		pmd = (pmd_t *)pgd;
		for (j = 0; j < PTRS_PER_PMD; pmd++, j++)
		{
			pte_base = pte = (pte_t *)get_zeroed_page(0);
			if (!pte_base)
			{
				printk("Memory: cannot allocate memory for page table.\n");
			}
			for (k = 0; k < PTRS_PER_PTE; pte++, k++)
			{
				vaddr = i * PGDIR_SIZE + j * PMD_SIZE + k * PAGE_SIZE;
				if (end && (vaddr >= end))
					break;
				*pte = mk_pte_phys(__pa(vaddr), PAGE_KERNEL);
			}
			set_pmd(pmd, __pmd(_KERNPG_TABLE + __pa(pte_base)));
		}
	}

	/* use new page tables */
	__asm__( "movl %%ecx,%%cr3\n" ::"c"(__pa(swapper_pg_dir)));
}

void reserve_mem_map(mem_map_t *mmap)
{
	int i;

	// zero page
	mmap->count = 1;
	// hw area, kernel area
	mmap += MAP_NR(0xa0000);
	for (i = 0; i < (MAP_NR(__pa(mmap + max_low_pfn))) - MAP_NR(0xa0000); i++, mmap++)
		mmap->count = 1;
}

void __init mem_init(void)
{
	printk("Memory: %luM available\n", max_low_pfn >> 8);

	/* init mem_map */
	mem_map_init();
	reserve_mem_map(mem_map);

	/* init paging */
	paging_init();

}
