/*
 * $Id: start_kernel.c,v 1.2 2002/09/09 05:44:23 halite Exp $
 *
 * Created by Halite on 2002.08.19
 */

#include <toykernel/kernel.h>
#include <toykernel/init.h>
#include <arch/system.h>

extern void __init setup_arch(char **);
extern void __init mem_init(void);
extern void __init trap_init(void);
extern void __init irq_init(void);
extern void __init timer_init(void);
extern void __init sched_init(void);

void start_kernel(void)
{
	char *cmdline;

	test_cls();
	printk("start toykernel...\n");

	/* set up something depends on a architecture */
	setup_arch(&cmdline);
	/* initialize things concerned with memory */
	mem_init();
	/* initialize traps */
	trap_init();
	irq_init();
	/* initialize timer */
	time_init();
	/* initialize scheduler */
	sched_init();

	sti();

	for(;;);
}

