/*
 * $Id: timer.c,v 1.1.1.1 2002/09/19 00:37:09 halite Exp $
 */

#include <toykernel/kernel.h>
#include <toykernel/timex.h>
#include <toykernel/sched.h>
#include <toykernel/kernel_stat.h>
#include <arch/param.h>
#include <arch/vm86.h>
#include <arch/ptrace.h>

long tick = (1000000 + HZ/2) / HZ;      /* timer interrupt period */
int time_status = STA_UNSYNC;

unsigned long volatile jiffies = 0;

#if 0
static inline void do_process_times(struct task_struct *p, unsigned long user, unsigned long system)
{
	unsigned long psecs;

	psecs = (p->times.tms_utime += user);
	psecs += (p->times.tms_stime += system);
	if (psecs / HZ > p->rlim[RLIMIT_CPU].rlim_cur) {
		/* Send SIGXCPU every second.. */
		if (!(psecs % HZ))
			send_sig(SIGXCPU, p, 1);
		/* and SIGKILL when we go over max.. */
		if (psecs / HZ > p->rlim[RLIMIT_CPU].rlim_max)
			send_sig(SIGKILL, p, 1);
	}
}

static inline void do_it_virt(struct task_struct * p, unsigned long ticks)
{
	unsigned long it_virt = p->it_virt_value;

	if (it_virt) {
		it_virt -= ticks;
		if (!it_virt) {
			it_virt = p->it_virt_incr;
			send_sig(SIGVTALRM, p, 1);
		}
		p->it_virt_value = it_virt;
	}
}

static inline void do_it_prof(struct task_struct *p)
{
	unsigned long it_prof = p->it_prof_value;

	if (it_prof) {
		if (--it_prof == 0) {
			it_prof = p->it_prof_incr;
			send_sig(SIGPROF, p, 1);
		}
		p->it_prof_value = it_prof;
	}
}

void update_one_process(struct task_struct *p, unsigned long user,
			unsigned long system, int cpu)
{
	p->per_cpu_utime[cpu] += user;
	p->per_cpu_stime[cpu] += system;
	do_process_times(p, user, system);
	do_it_virt(p, user);
	do_it_prof(p);
}	
#endif

/*
 * Called from the timer interrupt handler to charge one tick to the current 
 * process.  user_tick is 1 if the tick is user time, 0 for system.
 */
void update_process_times(int user_tick)
{
	struct task_struct *p = current;
	int cpu = 0;/*smp_processor_id()*/
	int system = user_tick ^ 1;

//	update_one_process(p, user_tick, system, cpu);
//printk("p=%x, counter=%d\n", p, p->counter);
	if (p->pid)
	{
		if (--p->counter <= 0)
		{
			p->counter = 0;
			p->need_resched = 1;
		}
		
		if (p->nice > 0)
			kstat.per_cpu_nice[cpu] += user_tick;
		else
			kstat.per_cpu_user[cpu] += user_tick;

		kstat.per_cpu_system[cpu] += system;
	}
#if 0
	else
	if (local_bh_count(cpu) || local_irq_count(cpu) > 1)
		kstat.per_cpu_system[cpu] += system;
#endif
}

void do_timer(struct pt_regs *regs)
{
	(*(unsigned long *)&jiffies)++;
//printk("do_timer : %d, %x, %d, %d\n", jiffies, current, current->counter, current->need_resched);
	update_process_times(user_mode(regs));
}

