/*
 * $Id$
 */

#include <toykernel/kernel.h>
#include <toykernel/errno.h>
#include <toykernel/mm.h>
#include <toykernel/sched.h>
#include <arch/ptrace.h>
#include <arch/processor.h>
#include <arch/current.h>

int nr_running;

int max_threads;
int last_pid;

static int get_pid(unsigned long flags)
{
	int next_safe = PID_MAX;
	int pid, beginpid;
	struct task_struct *p;

	beginpid = last_pid;
	if ((++last_pid & 0xffff8000))
	{
		last_pid = 300;
		goto inside;
	}

	if (last_pid >= next_safe)
	{
inside:
		next_safe = PID_MAX;
repeat:
		for_each_task(p)
		{
			if (p->pid == last_pid)
			{
				if (++last_pid >= next_safe)
				{
					if (last_pid & 0xffff8000)
						last_pid = 300;
					next_safe = PID_MAX;
				}
				if (unlikely(last_pid == beginpid))
					goto nomorepids;
				goto repeat;
			}
			if (p->pid > last_pid && next_safe > p->pid)
				next_safe = p->pid;
		}
	}

	pid = last_pid;
	return pid;

nomorepids:
		return 0;
}

int do_fork(unsigned long clone_flags, unsigned long stack_start, struct pt_regs *regs, unsigned long stack_size)
{
	int retval;
	struct task_struct *p;

	//if ((clone_flags & (CLONE_NEWNS|CLONE_FS)) == (CLONE_NEWNS|CLONE_FS))
	//	return -EINVAL;

	/* allocate a task struct */
	retval = -ENOMEM;
	p = alloc_task_struct();
	if (!p)
		goto fork_out;

	/* copy task struct from current task */
	*p = *current;

	retval = -EAGAIN;
	p->state = TASK_UNINTERRUPTIBLE;

	/* assign new pid */
	//copy_flags(clone_flags, p);
	p->pid = get_pid(clone_flags);

	p->run_list.next = NULL;
	p->run_list.prev = NULL;

	//p->lock_depth = -1;		/* -1 = no lock */
	//p->start_time = jiffies;

	/* set counter value */
	p->counter = (current->counter + 1) >> 1;
	current->counter >>= 1;
	if (!current->counter)
		current->need_resched = 1;

	retval = copy_thread(0, clone_flags, stack_start, stack_size, p, regs);
	if (retval)
		goto bad_fork_cleanup_namespace;

	retval = p->pid;
	//p->tgid = retval;
	//INIT_LIST_HEAD(&p->thread_group);

	SET_LINKS(p);

	/* wake up new process */
	wake_up_process(p);		/* do this last */

fork_out:
	return retval;
bad_fork_cleanup_namespace:
	//exit_namespace(p);
	goto fork_out;
}

void __init fork_init(unsigned long mempages)
{
	max_threads = mempages / (THREAD_SIZE/PAGE_SIZE) / 8;
}

