#ifndef _SCHED_H_
#define _SCHED_H_

#include <toykernel/types.h>
#include <toykernel/param.h>
#include <toykernel/tasks.h>
#include <toykernel/list.h>
#include <toykernel/threads.h>
#include <toykernel/compiler.h>
#include <arch/processor.h>
#include <arch/system.h>
#include <arch/pgtable.h>
#include <arch/current.h>
#include <arch/desc.h>
#include <arch/ptrace.h>

#define TASK_RUNNING			0
#define TASK_INTERRUPTIBLE		1
#define TASK_UNINTERRUPTIBLE	2
#define TASK_ZOMBIE				4
#define TASK_STOPPED			8

struct task_struct {
	volatile long		state;	/* -1 unrunnable, 0 runnable, >0 stopped */

	volatile long		need_resched;
	long				counter;
	long				nice;
	unsigned long		policy;

	struct task_struct	*next_task, *prev_task;
	int					exit_code, exit_signal;
	pid_t				pid, pgrp, session;
	int					leader;
	uid_t				uid, euid, suid;
	gid_t				gid, egid, sgid;
	int					ngroups;
	gid_t				groups[NGROUPS];
	struct list_head	run_list;
	struct thread_struct thread;
};

#define INIT_TASK(tsk) 										\
{ 															\
    state:				0,									\
    next_task:			&tsk,								\
    prev_task:			&tsk,								\
	thread:				INIT_THREAD							\
}

#ifndef INIT_TASK_SIZE
# define INIT_TASK_SIZE	2048*sizeof(long)
#endif

union task_union {
	struct task_struct task;
	unsigned long stack[INIT_TASK_SIZE/sizeof(long)];
};

extern union task_union init_task_union;

/*
 * Scheduling policies
 */
#define SCHED_OTHER		0
#define SCHED_FIFO		1
#define SCHED_RR		2

#define SCHED_YIELD		0x10

/* sched.c */
//extern struct task_struct *init_tasks[NR_CPUS];
extern unsigned long volatile jiffies;
extern struct timeval xtime;
extern void do_timer(struct pt_regs *);
extern int FASTCALL(wake_up_process(struct task_struct * tsk));
asmlinkage void schedule(void);

/* fork.c */
extern int nr_running;
extern int do_fork(unsigned long, unsigned long, struct pt_regs *, unsigned long);

/* processor.c */
extern int  copy_thread(int, unsigned long, unsigned long, unsigned long, struct task_struct *, struct pt_regs *);

#if 0
#define REMOVE_LINKS(p) do { \
	(p)->next_task->prev_task = (p)->prev_task; \
	(p)->prev_task->next_task = (p)->next_task; \
	if ((p)->p_osptr) \
		(p)->p_osptr->p_ysptr = (p)->p_ysptr; \
	if ((p)->p_ysptr) \
		(p)->p_ysptr->p_osptr = (p)->p_osptr; \
	else \
		(p)->p_pptr->p_cptr = (p)->p_osptr; \
	} while (0)
#endif
#define REMOVE_LINKS(p) do { \
	(p)->next_task->prev_task = (p)->prev_task; \
	(p)->prev_task->next_task = (p)->next_task; \
	} while (0)

#if 0
#define SET_LINKS(p) do { \
	(p)->next_task = &init_task; \
	(p)->prev_task = init_task.prev_task; \
	init_task.prev_task->next_task = (p); \
	init_task.prev_task = (p); \
	(p)->p_ysptr = NULL; \
	if (((p)->p_osptr = (p)->p_pptr->p_cptr) != NULL) \
		(p)->p_osptr->p_ysptr = p; \
	(p)->p_pptr->p_cptr = p; \
	} while (0)
#endif
#define SET_LINKS(p) do { \
	(p)->next_task = &init_task; \
	(p)->prev_task = init_task.prev_task; \
	init_task.prev_task->next_task = (p); \
	init_task.prev_task = (p); \
	} while (0)

#define for_each_task(p) \
	for (p = &init_task ; (p = p->next_task) != &init_task ; )

#define for_each_thread(task) \
	for (task = next_thread(current) ; task != current ; task = next_thread(task))

static inline int task_on_runqueue(struct task_struct *p)
{
	return (p->run_list.next != NULL);
}

#endif
