/*
 * Ʈ: TLE2Framework
 * ϸ: LoginCheckTag.java
 * ۼ: 2004. 11. 16
 */
package tle.framework.customtag;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.tagext.TagSupport;

import tle.framework.TLEFramework;
import tle.framework.component.spi.aamanager.AAManagerException;
import tle.framework.component.spi.aamanager.NullUser;
import tle.framework.component.spi.aamanager.User;

/**
 * α θ ˻ϴ ±.   login Ӽ  ؼ
 * α   (Ǵ α  ʾ ) ü  ش.
 * 
 * <pre>
 *   &lt;tle:loginCheck login="true">
 *   α   
 *   &lt;/tle:loginCheck>
 * </pre>
 * 
 * @author ֹ
 * @since 2.0
 */
public class LoginCheckTag extends TagSupport {
	private boolean login;
	
	public void setLogin(boolean login) {
		this.login = login;
	}
	
	public int doStartTag() throws JspException {
		boolean isLogin = false;
		try {
			User user = TLEFramework.getAAManagerProxy().
				getSessionUser((HttpServletRequest)pageContext.getRequest());
			if (user == null || user instanceof NullUser) {
				isLogin = false;
			} else {
				isLogin = true;
			}
		} catch (AAManagerException e) {
			throw new JspException(e);
		}
		if (isLogin == login) {
			return EVAL_BODY_INCLUDE;
		} else {
			return SKIP_BODY;
		}
	}
}
