/*
 * Ʈ: TLE2Framework
 * ϸ: DefaultUICreator.java
 * ۼ: 2004. 10. 28
 */
package tle.framework.component.impl.uicreator;

import java.io.File;
import java.io.IOException;

import javax.servlet.RequestDispatcher;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import tle.framework.component.ComponentConfig;
import tle.framework.component.ComponentException;
import tle.framework.component.impl.ComponentBase;
import tle.framework.component.impl.uicreator.client.ClientType;
import tle.framework.component.impl.uicreator.config.CommandConfig;
import tle.framework.component.impl.uicreator.config.UIConfiguration;
import tle.framework.component.impl.uicreator.config.UIConfigurationDigester;
import tle.framework.component.impl.uicreator.config.ViewConfig;
import tle.framework.component.impl.uicreator.config.ViewSetConfig;
import tle.framework.component.spi.ra.RequestInfo;
import tle.framework.component.spi.rp.Result;
import tle.framework.component.spi.uicreator.UICreator;
import tle.framework.log.Logger;
import tle.framework.util.TLEConfigPathUtil;

/**
 * UICreator ⺻  Ʈ.
 * 
 * @author ֹ
 * @since 2.0
 */
public class DefaultUICreator extends ComponentBase implements UICreator,
		DefaultUICreatorMBean {
	public static final String VIEW_CONFIG_ATTRIBUTE_NAME = "DefaultUICreator.ViewConfig";
	
	private UIConfiguration uiConfig;
	/**
	 *   θ 
	 */
	private String configFile;
	
	/**
	 *  Ϸκ  о UIConfiguration ü Ѵ.
	 * <p>
	 *   δ Ʈ ʱȭ Ķ "configFile" Ѵ.
	 * <p>
	 * configFile ʱȭ Ķ͸  ʾ  Ȩ丮 "DefaultUICreator.xml"  Ѵ.
	 *   
	 * @see tle.framework.component.impl.ComponentBase#initing(tle.framework.component.ComponentConfig)
	 */
	protected void initing(ComponentConfig config) throws ComponentException {
		String configFilePath = config.getInitParameter("configFile");

		if (configFilePath == null) {
			configFilePath = System.getProperty("user.home") + File.separator + "DefaultUICreator.xml";
		}
		this.configFile = configFilePath;
		
		try {
			this.initConfiguration();
		} catch (Throwable e) {
			Logger.fatal("DefaultUICreator.initing():Configuration File Loading Error", e);
			throw new ComponentException(e.getMessage(), e);
		}
	}
	
	/**
	 * result  ڵ忡  ˸  ̵Ѵ.
	 * result νϽ request "result" Ӽ ȴ.
	 * 
	 * @see tle.framework.component.spi.uicreator.UICreator#createView(tle.framework.component.spi.rp.Result, javax.servlet.http.HttpServletRequest, javax.servlet.http.HttpServletResponse)
	 */
	public void createView(Result result, HttpServletRequest request,
			HttpServletResponse response) throws ComponentException {
		ViewSetConfig viewSet = getViewSetConfig(request);
		CommandConfig commandConfig = uiConfig.getCommandConfig(result.getCommandID());
		if (commandConfig == null)
			throw new ComponentException("Not Matching UI CommandConfig for command:"+result.getCommandID());
		
		String resultViewID = commandConfig.getResultViewID(result.getCode());
		ViewConfig viewConfig = viewSet.getViewConfig(resultViewID);
		if (viewConfig == null) {
			throw new ComponentException("Not Matching UI ViewConfig for [command,resultcode]:["+result.getCommandID()+","+result.getCode()+"]");
		}
		request.setAttribute("result", result);
		
		try {
			this.forward(viewConfig, request, response);
		} catch (ServletException e) {
			throw new ComponentException(e.getMessage(), e);
		} catch (IOException e) {
			throw new ComponentException(e.getMessage(), e);
		}
	}

	/**
	 * ȭ ̵Ѵ.
	 * 
	 * @see tle.framework.component.spi.uicreator.UICreator#createAuthenticationForm(javax.servlet.http.HttpServletRequest, javax.servlet.http.HttpServletResponse)
	 */
	public void createAuthenticationForm(HttpServletRequest request,
			HttpServletResponse response) throws ComponentException {
		ViewSetConfig viewSet = getViewSetConfig(request);
		ViewConfig viewConfig = viewSet.getAuthFormViewConfig();
		try {
			this.forward(viewConfig, request, response);
		} catch (ServletException e) {
			throw new ComponentException(e.getMessage(), e);
		} catch (IOException e) {
			throw new ComponentException(e.getMessage(), e);
		}
	}

	/**
	 * Ѿٴ ޽ ִ ȭ ̵Ѵ.
	 * 
	 * @see tle.framework.component.spi.uicreator.UICreator#createNoAuthorizationView(tle.framework.component.spi.ra.RequestInfo, javax.servlet.http.HttpServletRequest, javax.servlet.http.HttpServletResponse)
	 */
	public void createNoAuthorizationView(RequestInfo ri,
			HttpServletRequest request, HttpServletResponse response)
			throws ComponentException {
		ViewSetConfig viewSet = getViewSetConfig(request);
		ViewConfig viewConfig = viewSet.getNoAuthViewConfig();
		try {
			this.forward(viewConfig, request, response);
		} catch (ServletException e) {
			throw new ComponentException(e.getMessage(), e);
		} catch (IOException e) {
			throw new ComponentException(e.getMessage(), e);
		}
	}

	/**
	 *   ȭ ̵Ѵ.
	 * <p>
	 * result νϽ request "result" Ӽ ȴ.
	 * <p>
	 * result.getException() ϴ  ü request
	 * javax.servlet.error.exception Ӽ javax.servlet.jsp.jspException Ӽ
	 * Ѵ.
	 * 
	 * @see tle.framework.component.spi.uicreator.UICreator#createErrorView(tle.framework.component.spi.rp.Result, javax.servlet.http.HttpServletRequest, javax.servlet.http.HttpServletResponse)
	 */
	public void createErrorView(Result result, HttpServletRequest request,
			HttpServletResponse response) throws ComponentException {
		ViewSetConfig viewSet = getViewSetConfig(request);
		ViewConfig viewConfig = viewSet.getErrorViewConfig();
		
		request.setAttribute("result", result);
		if (result.isErrorOccured() && result.getException() != null) {
			request.setAttribute("javax.servlet.error.exception", result.getException());
			request.setAttribute("javax.servlet.jsp.jspException", result.getException());
		}
		try {
			this.forward(viewConfig, request, response);
		} catch (ServletException e) {
			throw new ComponentException(e.getMessage(), e);
		} catch (IOException e) {
			throw new ComponentException(e.getMessage(), e);
		}
	}

	/**
	 *   ȭ ̵Ѵ.
	 * <p>
	 * ڷ ޹ Throwable ü request
	 * javax.servlet.error.exception Ӽ javax.servlet.jsp.jspException Ӽ
	 * Ѵ.
	 * @see tle.framework.component.spi.uicreator.UICreator#createErrorView(java.lang.Throwable, javax.servlet.http.HttpServletRequest, javax.servlet.http.HttpServletResponse)
	 */
	public void createErrorView(Throwable exception, HttpServletRequest request, HttpServletResponse response) throws ComponentException {
		ViewSetConfig viewSet = getViewSetConfig(request);
		ViewConfig viewConfig = viewSet.getErrorViewConfig();
		
		request.setAttribute("javax.servlet.error.exception", exception);
		request.setAttribute("javax.servlet.jsp.jspException", exception);
		
		try {
			this.forward(viewConfig, request, response);
		} catch (ServletException e) {
			throw new ComponentException(e.getMessage(), e);
		} catch (IOException e) {
			throw new ComponentException(e.getMessage(), e);
		}
	}

	/**
	 * User-Agent  ViewSetConfig Ѵ.
	 * 
	 * @param request HTTP û
	 */
	private ViewSetConfig getViewSetConfig(HttpServletRequest request) {
		String clientType = ClientType.getClientType(request);
		return uiConfig.getClientViewSetConfig(clientType);
	}
	
	/**
	 * viewConfig Ÿ  ̵Ѵ.
	 * <p>
	 * ViewConfig ü request DefaultUICreator.ViewConfig Ӽ Ѵ.
	 * <p>
	 * viewConfig.getRelatedPage() ޼ҵ ϰ ̵  URI Ѵ.
	 * 
	 * @param viewConfig   
	 * @param request HTTP û
	 * @param response HTTP 
	 * @throws ServletException
	 * @throws IOException
	 */
	private void forward(ViewConfig viewConfig, HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
		request.setAttribute(VIEW_CONFIG_ATTRIBUTE_NAME, viewConfig);
		RequestDispatcher dispatcher = request.getRequestDispatcher(viewConfig.getRelatedPage());
		dispatcher.forward(request, response);
	}
	
	/**
	 * @see tle.framework.component.impl.uicreator.DefaultUICreatorMBean#getConfigFile()
	 */
	public String getConfigFile() {
		return configFile;
	}
	/**
	 *  Ϸκ   о uiConfig ʵ忡 ҴѴ.
	 * 
	 * @throws Throwable
	 */
	private void initConfiguration() throws Throwable {
		uiConfig = UIConfigurationDigester.create(TLEConfigPathUtil.replace(configFile));
	}
	
	/**
	 *  Ϸκ   ٽ о´.
	 * @see tle.framework.component.impl.uicreator.DefaultUICreatorMBean#reloadConfiguration()
	 */
	public void reloadConfiguration() throws ComponentException {
		try {
			initConfiguration();
		} catch (Throwable e) {
			Logger.fatal("DefaultUICreator.reloadConfiguration():Configuration File Loading Error", e);
			throw new ComponentException(e.getMessage(), e);
		}
	}

}
