/*
 * Ʈ: TLE2Framework
 * ϸ: DefaultRPConfiguration.java
 * ۼ: 2004. 10. 25
 */
package tle.framework.component.impl.rp.config;

import java.util.List;
import java.util.Map;

/**
 * DefaultRequestProcessor   ϴ Ŭ.
 * 
 * @author ֹ
 * @since 2.0
 */
public class DefaultRPConfiguration {
	private boolean usingIndependentClassPath;
	private List classPathList = new java.util.ArrayList(10);
	private Map handlerClassMap = new java.util.HashMap();
	private Map handlerJspMap = new java.util.HashMap();
	private Map commandHandlerMap = new java.util.HashMap();
	
	public static final int DEFAULT_GOVIEW = 0x01;
	public static final int DEFAULT_NOHANDLER = 0x02;
	/**
	 * ɾ  ڵ鷯 õǾ     ⺻ ڵ鷯 Ѵ.
	 * ⺻  ERROR
	 */
	private int defaultHandlerType = DEFAULT_NOHANDLER;
	
	public void setUsingIndependentClassPath(boolean b) {
		this.usingIndependentClassPath = b;
	}
	public boolean isUsingIndependentClassPath() {
		return usingIndependentClassPath;
	}
	
	public void addClassPath(String classPath) {
		classPathList.add(classPath);
	}
	public String[] getClassPathArray() {
		String[] classPathArray = new String[classPathList.size()];
		classPathList.toArray(classPathArray);
		return classPathArray;
	}
	
	public void addHandlerClass(String handlerID, String handlerClassName, String jspPage) {
		if (jspPage != null) {
			handlerJspMap.put(handlerID, jspPage);
		} else {
			handlerClassMap.put(handlerID, handlerClassName);
		}
	}
	public Map getHandlerClassMap() {
		return handlerClassMap;
	}
	public Map getHandlerJspMap() {
		return handlerJspMap;
	}
	public void setDefaultHandler(String type) {
		if (type.compareTo("GOVIEW") == 0) {
			this.defaultHandlerType = DEFAULT_GOVIEW;
		} else if (type.compareTo("NOHANDLER") == 0) { 
			this.defaultHandlerType = DEFAULT_NOHANDLER;
		} else {
			throw new IllegalArgumentException("Invalid type value:"+type);
		}
	}
	public int getDefaultHandlerType() {
		return defaultHandlerType; 
	}
	public void addCommandHandlerMapping(String commandID, String handlerID) {
		commandHandlerMap.put(commandID, handlerID);
	}
	public Map getCommandHandlerMap() {
		return commandHandlerMap;
	}
}
