/*
 * Ʈ: TLE2Framework
 * ϸ: DefaultResult.java
 * ۼ: 2004. 10. 22
 */
package tle.framework.component.impl.rp;

import java.util.List;
import java.util.Map;

import tle.framework.component.spi.rp.Result;

/**
 * Result  Ŭ.
 * 
 * @author ֹ
 * @since 2.0
 */
public class DefaultResult implements Result {
	
	/**
	 * ɾ ID
	 */
	private String commandID;
	/**
	 *  ڵ带 Ѵ.
	 */
	private String code;
	/**
	 * UI  ͸ Ѵ.
	 */
	private Map dataMap;
	/**
	 *  ߻ߴ  θ Ÿ.
	 */
	private boolean errorOccured;
	/**
	 * ڵ鷯 û óϴ  ߻  ü Ѵ.
	 */
	private Throwable exception;
	/**
	 *  ޽  ϴ Ʈ
	 */
	private List errorMessageList;
	
	/**
	 *   ɾID ޹޴´.
	 * 
	 * @param commandID
	 */
	public DefaultResult(String commandID) {
		this.commandID = commandID;
		errorOccured = false;
	}
	
	/**
	 * @see tle.framework.component.spi.rp.Result#getCommandID()
	 */
	public String getCommandID() {
		return commandID;
	}
	
	/**
	 *  ڵ带 Ѵ.
	 * @param code
	 */
	public void setCode(String code) {
		this.code = code;
	}
	
	/**
	 * setCode() ޹  ڵ带 Ѵ.
	 * 
	 * @see tle.framework.component.spi.rp.Result#getCode()
	 */
	public String getCode() {
		return code;
	}
	
	/**
	 * &lt;name, value>  Ѵ.
	 *  
	 * @param name
	 * @param value
	 */
	public void setData(String name, Object value) {
		if (dataMap == null) {
			dataMap = new java.util.HashMap();
		}
		dataMap.put(name, value);
	}
	
	/**
	 * dataMapκ name شϴ  Ѵ.
	 * 
	 * @see tle.framework.component.spi.rp.Result#getData(java.lang.String)
	 */
	public Object getData(String name) {
		if (dataMap == null) return null;
		return dataMap.get(name);
	}
	
	/**
	 *  ߻ߴ θ Ѵ.
	 * 
	 * @param b
	 */
	public void setErrorOccured(boolean b) {
		errorOccured = b;
	}
	
	/**
	 * @see tle.framework.component.spi.rp.Result#isErrorOccured()
	 */
	public boolean isErrorOccured() {
		return errorOccured;
	}
	
	/**
	 * û óϴ  ߻ ܸ Ѵ. 
	 * @param e
	 */
	public void setException(Throwable e) {
		this.exception = e;
	}
	
	/**
	 * setException() ޼ҵ   ü Ѵ.
	 * @see tle.framework.component.spi.rp.Result#getException()
	 */
	public Throwable getException() {
		return exception;
	}
	
	/**
	 *  ޽ ߰Ѵ.
	 * @param messsage
	 */
	public void addErrorMessage(String message) {
		if (errorMessageList == null) {
			errorMessageList = new java.util.ArrayList(4);
		}
		errorMessageList.add(message);
	}
	
	/**
	 * addErrorMessage() ޼ҵ ߰  ޽ 迭 Ѵ.
	 *    ̰ null Ѵ.
	 * @see tle.framework.component.spi.rp.Result#getErrorMessage()
	 */
	public String[] getErrorMessage() {
		if (errorMessageList == null) return null;
		String[] errorMessageArray = new String[errorMessageList.size()];
		errorMessageList.toArray(errorMessageArray);
		return errorMessageArray;
	}
}
