/*
 * Ʈ: TLE2Framework
 * ϸ: DefaultRequestProcessor.java
 * ۼ: 2004. 10. 22
 */
package tle.framework.component.impl.rp;

import java.io.File;

import tle.framework.component.ComponentConfig;
import tle.framework.component.ComponentException;
import tle.framework.component.impl.ComponentBase;
import tle.framework.component.impl.rp.config.DefaultRPConfiguration;
import tle.framework.component.impl.rp.config.DefaultRPConfigurationDigester;
import tle.framework.component.impl.rp.handler.CommandHandler;
import tle.framework.component.impl.rp.handler.CommandHandlerFactory;
import tle.framework.component.impl.rp.handler.NoHandlerCommandHandler;
import tle.framework.component.spi.ra.RequestInfo;
import tle.framework.component.spi.rp.RequestProcessor;
import tle.framework.component.spi.rp.Result;
import tle.framework.log.Logger;
import tle.framework.util.TLEConfigPathUtil;

/**
 * RequestProcessor ⺻ ü.
 * <p>
 * TLEFramework ʱ   "configFile" ʱȭ Ķͷ  Ϸκ ʱ   о´.
 *  "configFile" ʱȭ Ƽ  ʾ 쿡
 *  Ȩ 丮 "DefaultRequestProcessor.xml"  Ѵ.
 * 
 * @author ֹ
 * @since 2.0
 */
public class DefaultRequestProcessor extends ComponentBase implements
		RequestProcessor, DefaultRequestProcessorMBean {
	
	private CommandHandlerFactory handlerFactory;
	private String configFilePath;
	private DefaultRPConfiguration configuration;
	
	/**
	 * @see tle.framework.component.impl.rp.DefaultRequestProcessorMBean#getConfigFilePath()
	 */
	public String getConfigFilePath() {
		return configFilePath;
	}

	/**
	 * @see tle.framework.component.impl.rp.DefaultRequestProcessorMBean#isUsingHandlerIndependentClassPath()
	 */
	public boolean isUsingHandlerIndependentClassPath() {
		return configuration.isUsingIndependentClassPath();
	}

	/**
	 * @see tle.framework.component.impl.rp.DefaultRequestProcessorMBean#getHandlerIndependentClassPath()
	 */
	public String[] getHandlerIndependentClassPath() {
		return configuration.getClassPathArray();
	}

	/**
	 * ڵ鷯 Ŭ   Ŭ н ϴ ,  
	 * CommandHandlerFactory.reloadHandlerClasses() ޼ҵ带 ȣѴ.
	 *   
	 * @see tle.framework.component.impl.rp.DefaultRequestProcessorMBean#reloadHandlerClasses()
	 * @throws java.lang.UnsupportedOperationException  Ŭ н  ʴ ɷ Ǿ ִ  ߻Ѵ. 
	 */
	public void reloadHandlerClasses() {
		if (configuration.isUsingIndependentClassPath()) {
			handlerFactory.reloadHandlerClasses(configuration);
		} else {
			throw new UnsupportedOperationException("usingHandlerIndependentClassPath != true");
		}
	}
	
	
	/**
	 *   εѴ.
	 * <p>
	 * ڵ鷯 Ŭ  ٽ ϰ ɾ ڵ鷯    ٽ Ѵ.
	 * 
	 * @see tle.framework.component.impl.rp.DefaultRequestProcessorMBean#reloadConfiguration()
	 */
	public void reloadConfiguration() throws ComponentException {
		try {
			DefaultRPConfiguration newConfiguration = DefaultRPConfigurationDigester.create(TLEConfigPathUtil.replace(configFilePath));
			this.configuration = newConfiguration;
		} catch (Throwable e) {
			Logger.fatal("DefaultRequestProcessor.reloadConfiguration():Configuration File Loading Error", e);
			throw new ComponentException(e.getMessage(), e);
		}
		handlerFactory.init(configuration);
	}
	/**
	 *  Ϸκ  о CommandHandlerFactory Ѵ.
	 * <p>
	 *   δ <i>configFile</i> ʱȭ Ķͷκ ´.
	 * 
	 * @see tle.framework.component.impl.ComponentBase#initing(tle.framework.component.ComponentConfig)
	 */
	protected void initing(ComponentConfig config) throws ComponentException {
		this.configFilePath = config.getInitParameter("configFile");

		if (configFilePath == null) {
			configFilePath = System.getProperty("user.home") + File.separator + "DefaultRequestProcessor.xml";
		}
		try {
			configuration = DefaultRPConfigurationDigester.create(TLEConfigPathUtil.replace(configFilePath));
		} catch (Throwable e) {
			Logger.fatal("DefaultRequestProcessor.initing():Configuration File Loading Error", e);
			throw new ComponentException(e.getMessage(), e);
		}
		handlerFactory = new CommandHandlerFactory(configuration);
	}
	
	/**
	 * ɾ óϴ CommandHandler Ͽ Ŭ̾Ʈ û ó 
	 *   DefaultResult Ѵ.
	 * <p>
	 * CommandHandler ̸ process() ޼ҵ忡 Ŭ̾Ʈ û óϴ  
	 * ߻   ϴ Result ־ ϸ ܸ ߻Ű  ȴ.
	 * 
	 * @see tle.framework.component.spi.rp.RequestProcessor#process(tle.framework.component.spi.ra.RequestInfo)
	 * @throws tle.framework.component.ComponentException ɾ ID شϴ CommandHandler NoHandlerCommandHandler 쿡 ߻Ѵ. 
	 */
	public Result process(RequestInfo ri) throws ComponentException {
		CommandHandler handler = handlerFactory.createCommandHandler(ri);
		if (handler instanceof NoHandlerCommandHandler) {
			throw new ComponentException("NO HANDLER:"+ri.getCommandID());
		}
		DefaultResult result = new DefaultResult(ri.getCommandID());
		
		try {
			result = handler.process(ri, result);
		} catch(Throwable e) {
			//  ܴ CommandHandler  ó  ̴.
			throw new ComponentException(e.getMessage(), e);
		}
		return result;
	}
}
