/*
 * Decompiled with CFR 0.152.
 */
package tle.framework.component.impl.ra;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.fileupload.DiskFileUpload;
import org.apache.commons.fileupload.FileItem;
import org.apache.commons.fileupload.FileUpload;
import org.apache.commons.fileupload.FileUploadException;
import tle.framework.component.ComponentConfig;
import tle.framework.component.ComponentException;
import tle.framework.component.impl.ComponentBase;
import tle.framework.component.impl.ra.DefaultFileItem;
import tle.framework.component.impl.ra.DefaultRequestAnalyzerMBean;
import tle.framework.component.impl.ra.DefaultRequestInfo;
import tle.framework.component.spi.ra.RequestAnalyzer;
import tle.framework.component.spi.ra.RequestAnalyzerException;
import tle.framework.component.spi.ra.RequestInfo;
import tle.framework.log.Logger;
import tle.framework.util.TLEConfigPathUtil;

public class DefaultRequestAnalyzer
extends ComponentBase
implements RequestAnalyzer,
DefaultRequestAnalyzerMBean {
    private String tempDir;
    private long max;
    private String encoding;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void initing(ComponentConfig config) throws ComponentException {
        String configFilePath = config.getInitParameter("configFile");
        if (configFilePath == null) {
            configFilePath = System.getProperty("user.home") + File.separator + "DefaultRequestAnalyzer.properties";
        }
        Properties properties = new Properties();
        File file = new File(TLEConfigPathUtil.replace(configFilePath));
        if (file.exists() && file.canRead()) {
            FileInputStream fis = null;
            fis = new FileInputStream(file);
            properties.load(fis);
            this.tempDir = properties.getProperty("tempDir");
            try {
                String maxStr = properties.getProperty("max");
                if (maxStr != null && (maxStr = maxStr.trim()).length() > 0) {
                    char lastCh = maxStr.charAt(maxStr.length() - 1);
                    String value = null;
                    long multi = 1L;
                    if (lastCh == 'k' || lastCh == 'K') {
                        multi = 1024L;
                        value = maxStr.substring(0, maxStr.length() - 1);
                    } else if (lastCh == 'm' || lastCh == 'M') {
                        multi = 0x100000L;
                        value = maxStr.substring(0, maxStr.length() - 1);
                    } else if (lastCh == 'g' || lastCh == 'M') {
                        multi = 0x40000000L;
                        value = maxStr.substring(0, maxStr.length() - 1);
                    } else {
                        value = maxStr;
                    }
                    this.max = multi * Long.parseLong(value);
                }
            }
            catch (Throwable t) {
                if (Logger.isWarnEnabled()) {
                    Logger.warn("DefaultRequestAnalyzer.initing():invalid max property value=" + properties.getProperty("max"), t);
                }
                this.max = -1L;
            }
            this.encoding = properties.getProperty("encoding");
            Object var12_12 = null;
            if (fis == null) return;
            try {
                fis.close();
                return;
            }
            catch (IOException ex2) {}
            return;
            {
                catch (IOException ex) {
                    if (Logger.isWarnEnabled()) {
                        Logger.warn("DefaultRequestAnalyzer.initing():Property File Loading Error", ex);
                    }
                    Object var12_13 = null;
                    if (fis == null) return;
                    try {
                        fis.close();
                        return;
                    }
                    catch (IOException ex2) {}
                    return;
                }
            }
            catch (Throwable throwable) {
                Object var12_14 = null;
                if (fis == null) throw throwable;
                try {
                    fis.close();
                    throw throwable;
                }
                catch (IOException ex2) {
                    // empty catch block
                }
                throw throwable;
            }
        }
        this.tempDir = System.getProperty("user.home");
        this.max = -1L;
        this.encoding = properties.getProperty("file.encoding");
    }

    public RequestInfo analyzeRequest(HttpServletRequest request, HttpServletResponse response) throws RequestAnalyzerException {
        DefaultRequestInfo requestInfo = new DefaultRequestInfo(request, response);
        String characterEncoding = this.encoding;
        if (characterEncoding == null) {
            characterEncoding = request.getCharacterEncoding();
        }
        if (FileUpload.isMultipartContent((HttpServletRequest)request)) {
            DiskFileUpload fileUpload = new DiskFileUpload();
            fileUpload.setSizeMax(this.max);
            fileUpload.setRepositoryPath(this.tempDir);
            try {
                List itemList = fileUpload.parseRequest(request);
                HashMap paramMap = new HashMap();
                for (int i = 0; i < itemList.size(); ++i) {
                    FileItem item = (FileItem)itemList.get(i);
                    if (item.isFormField()) {
                        String name = item.getFieldName();
                        String value = null;
                        try {
                            value = item.getString(characterEncoding);
                            ArrayList<String> params = (ArrayList<String>)paramMap.get(name);
                            if (params == null) {
                                params = new ArrayList<String>(2);
                            }
                            params.add(value);
                            continue;
                        }
                        catch (UnsupportedEncodingException e1) {
                            throw new RequestAnalyzerException(e1.getMessage(), e1);
                        }
                    }
                    DefaultFileItem fileItem = new DefaultFileItem();
                    fileItem.init(item);
                    requestInfo.addFileItem(fileItem.getParameterName(), fileItem);
                }
                Iterator paramIter = paramMap.keySet().iterator();
                while (paramIter.hasNext()) {
                    String paramName = (String)paramIter.next();
                    List list = (List)paramMap.get(paramName);
                    String[] values = new String[list.size()];
                    list.toArray(values);
                    requestInfo.addParameter(paramName, values);
                }
            }
            catch (FileUploadException e) {
                throw new RequestAnalyzerException(e.getMessage(), e);
            }
        } else {
            Enumeration enumeration = request.getParameterNames();
            while (enumeration.hasMoreElements()) {
                String name = (String)enumeration.nextElement();
                String[] values = request.getParameterValues(name);
                if (values == null) continue;
                requestInfo.addParameter(name, values);
            }
        }
        String uri = request.getRequestURI();
        String contextPath = request.getContextPath();
        String commandID = null;
        commandID = contextPath.compareTo("") == 0 ? uri : uri.substring(contextPath.length());
        requestInfo.setCommandID(commandID);
        return requestInfo;
    }

    public String getTempDir() {
        return this.tempDir;
    }

    public void setTempDir(String tempDir) {
        this.tempDir = tempDir;
    }

    public long getMax() {
        return this.max;
    }

    public void setMax(long max) {
        this.max = max;
    }

    public String getEncoding() {
        return this.encoding;
    }

    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }
}

