/*
 * Decompiled with CFR 0.152.
 */
package tle.framework.component.impl.aamanager.session;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import tle.framework.component.ComponentConfig;
import tle.framework.component.impl.aamanager.SessionManager;
import tle.framework.component.spi.aamanager.AAManagerException;
import tle.framework.component.spi.aamanager.User;

public class SessionManagerImpl
implements SessionManager {
    private String sessionAttributeName;

    public void init(ComponentConfig configuration) throws AAManagerException {
        this.sessionAttributeName = configuration.getInitParameter("SessionManagerImpl.sessionAttributeName");
        if (this.sessionAttributeName == null) {
            this.sessionAttributeName = "user";
        }
    }

    public void openSession(User user, HttpServletRequest request, HttpServletResponse response) {
        HttpSession session = request.getSession();
        session.setAttribute(this.sessionAttributeName, (Object)user);
    }

    public void closeSession(HttpServletRequest request, HttpServletResponse response) throws AAManagerException {
        HttpSession session = request.getSession(false);
        if (session != null) {
            session.invalidate();
        }
    }

    public User getSessionUser(HttpServletRequest request) throws AAManagerException {
        Object user;
        HttpSession session = request.getSession(false);
        if (session != null && (user = session.getAttribute(this.sessionAttributeName)) instanceof User) {
            return (User)user;
        }
        return null;
    }
}

