package tle.searchutil.hibernate3;

import java.util.ArrayList;
import java.util.List;
import java.util.Stack;

import org.hibernate.Criteria;
import org.hibernate.Hibernate;
import org.hibernate.Query;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Junction;
import org.hibernate.criterion.MatchMode;
import org.hibernate.criterion.Restrictions;

import tle.searchutil.CompositeCond;
import tle.searchutil.Cond;
import tle.searchutil.Match;
import tle.searchutil.OneZero;
import tle.searchutil.Order;
import tle.searchutil.PropertyCond;
import tle.searchutil.PropertyValueCond;
import tle.searchutil.PropertyValuesCond;
import tle.searchutil.QueryHelper;
import tle.searchutil.SearchFilter;
import tle.searchutil.SingleCond;
import tle.searchutil.TrueFalse;
import tle.searchutil.TwoPropertyCond;
import tle.searchutil.YesNo;
import tle.searchutil.impl.CondAnd;
import tle.searchutil.impl.CondBetween;
import tle.searchutil.impl.CondEmpty;
import tle.searchutil.impl.CondEq;
import tle.searchutil.impl.CondEqProperty;
import tle.searchutil.impl.CondGe;
import tle.searchutil.impl.CondGeProperty;
import tle.searchutil.impl.CondGt;
import tle.searchutil.impl.CondGtProperty;
import tle.searchutil.impl.CondIdEq;
import tle.searchutil.impl.CondIlike;
import tle.searchutil.impl.CondIn;
import tle.searchutil.impl.CondLe;
import tle.searchutil.impl.CondLeProperty;
import tle.searchutil.impl.CondLike;
import tle.searchutil.impl.CondLt;
import tle.searchutil.impl.CondLtProperty;
import tle.searchutil.impl.CondNe;
import tle.searchutil.impl.CondNeProperty;
import tle.searchutil.impl.CondNot;
import tle.searchutil.impl.CondNotEmpty;
import tle.searchutil.impl.CondNotIn;
import tle.searchutil.impl.CondNotNull;
import tle.searchutil.impl.CondNull;
import tle.searchutil.impl.CondOr;

public class Hibernate3QueryHelper extends QueryHelper {
	public Hibernate3QueryHelper() {
	}
	
	/**
	 * Query parameter ˸  ҴѴ.
	 * @param query
	 * @param filter
	 * @param startIdx
	 * @param parameterValues Ķ  ϰ ִ List
	 */
	public void setParameter(Query query,  
			int startIdx, List parameterValues) {
		for (int i = 0 ; i < parameterValues.size() ; i++) {
			Object value = parameterValues.get(i);
			if (value instanceof YesNo) {
				query.setParameter(i + startIdx, ((YesNo)value).getValue(), Hibernate.YES_NO);
			} else if (value instanceof TrueFalse) {
				query.setParameter(i + startIdx, ((TrueFalse)value).getValue(), Hibernate.TRUE_FALSE);
			} else if (value instanceof OneZero) {
				query.setParameter(i + startIdx, ((OneZero)value).getValue(), Hibernate.BOOLEAN);
			} else {
				// TODO ŸԺ Ưȭ ó ʿ
				query.setParameter(i + startIdx, value);
			}
		}
	}
	
	/**
	 * crit ˻  ߰Ѵ.
	 * 
	 * @param crit
	 * @param filter
	 */
	public void appendCriterion(Criteria crit, SearchFilter filter) {
		Stack stackList = new Stack(); //  List
		Stack stacki = new Stack(); //  i 
		Stack stackJunction = new Stack(); //  composite OP
		
		List conds = filter.getConds();
		
		Object currentJunction = crit; 
		
		for (int i = 0 ; i < conds.size() ; i++) {
			Cond cond = (Cond)conds.get(i);
			if (cond instanceof CompositeCond) {
				stackList.push(conds);
				stacki.push(new Integer(i));
				stackJunction.push(currentJunction);
				
				if (cond instanceof CondAnd) {
					currentJunction = Restrictions.conjunction();
				} else if (cond instanceof CondOr) {
					currentJunction = Restrictions.disjunction();
				}
				
				conds = ((CompositeCond)cond).getConds();
				i = -1;
				continue;
			} else if (cond instanceof SingleCond) {
				stackList.push(conds);
				stacki.push(new Integer(i));
				stackJunction.push(currentJunction);
				
				currentJunction = cond;
				List tempList = new ArrayList(1);
				tempList.add(((SingleCond)cond).getCond());
				conds = tempList;
				i = -1;
				continue;
			} else {
				if (currentJunction instanceof Criteria) {
					((Criteria)currentJunction).add(createCreterion(cond));
				} else if (currentJunction instanceof Junction) {
					((Junction)currentJunction).add(createCreterion(cond));
				}
			
				// CondNot CompositeCond/SingleCond ƴ Cond  
				// ڿ ó.
			}
			while (i == conds.size() - 1) {
				//   ó  ÿ ִ
				// junction  junction ߰Ѵ.
				if (stackList.size() > 0) {
					conds = (List)stackList.pop();
					i = ((Integer)stacki.pop()).intValue();
					Object parentJunction = stackJunction.pop(); // 
					
					if (currentJunction instanceof Junction) {
						if (parentJunction instanceof Criteria) {
							((Criteria)parentJunction).add((Junction)currentJunction);
						} else if (parentJunction instanceof Junction) {
							((Junction)parentJunction).add((Junction)currentJunction);
						} else if (parentJunction instanceof CondNot) {
							//  CondNot̸ ݵ   
							// ,   not(currentJunction) ߰ϸ ȴ.
							Object grandParentJunction = stackJunction.peek();
							if (grandParentJunction instanceof Criteria) {
								((Criteria)grandParentJunction).add(Restrictions.not((Junction)currentJunction));
							} else if (grandParentJunction instanceof Junction) {
								((Junction)grandParentJunction).add(Restrictions.not((Junction)currentJunction));
							}							
						}
					} else if (currentJunction instanceof CondNot) {
						// CondNot CompositeCond/SingleCond ƴ Cond  
						// CondNot  ݵ  
						if (parentJunction instanceof Criteria) {
							((Criteria)parentJunction).add(Restrictions.not(createCreterion(cond)));
						} else if (parentJunction instanceof Junction) {
							((Junction)parentJunction).add(Restrictions.not(createCreterion(cond)));
						}
					}
					currentJunction = parentJunction;
				} else {
					break;
				}
				try {
					Thread.sleep(100);
				} catch (InterruptedException e) {
					// TODO Auto-generated catch block
					e.printStackTrace();
				}
			}
		}
	}
	
	/**
	 * cond ŸԿ  ˸ Criterion Ѵ.
	 * @param cond
	 * @return
	 */
	private Criterion createCreterion(Cond cond) {
		if (cond instanceof PropertyValueCond) {
			PropertyValueCond valueCond = (PropertyValueCond)cond;
			
			if (valueCond instanceof CondEq) {
				Object value = valueCond.getValue();
				if (value instanceof YesNo) {
					return Restrictions.eq(valueCond.getPropertyName(), ((YesNo)value).getValue());
				} else if (value instanceof TrueFalse) {
					return Restrictions.eq(valueCond.getPropertyName(), ((TrueFalse)value).getValue());
				} else if (value instanceof OneZero) {
					return Restrictions.eq(valueCond.getPropertyName(), ((OneZero)value).getValue());
				} else {
					return Restrictions.eq(valueCond.getPropertyName(), value);
				}
			} else if (valueCond instanceof CondGe) {
				return Restrictions.ge(valueCond.getPropertyName(), valueCond.getValue());
			} else if (valueCond instanceof CondGt) {
				return Restrictions.gt(valueCond.getPropertyName(), valueCond.getValue());
			} else if (valueCond instanceof CondIdEq) {
				return Restrictions.idEq(valueCond.getValue());
			} else if (valueCond instanceof CondLe) {
				return Restrictions.le(valueCond.getPropertyName(), valueCond.getValue());
			} else if (valueCond instanceof CondLike) {
				CondLike likeCond = (CondLike)valueCond;
				MatchMode mode = null;
				switch(likeCond.getMatch()) {
				case Match.ANYWHERE:
					mode = MatchMode.ANYWHERE;
					break;
				case Match.START:
					mode = MatchMode.START;
					break;
				case Match.END:
					mode = MatchMode.END;
					break;
				case Match.EXACT:
					mode = MatchMode.EXACT;
					break;
				default:
					mode = MatchMode.ANYWHERE;
				}
				if (valueCond instanceof CondIlike) {
					return Restrictions.ilike(valueCond.getPropertyName(), likeCond.getValueString(), mode);
				} else {
					return Restrictions.like(valueCond.getPropertyName(), likeCond.getValueString(), mode);
				}
			} else if (valueCond instanceof CondLt) {
				return Restrictions.lt(valueCond.getPropertyName(), valueCond.getValue());
			} else if (valueCond instanceof CondNe) {
				return Restrictions.ne(valueCond.getPropertyName(), valueCond.getValue());
			}
			
		} else if (cond instanceof TwoPropertyCond) {
			TwoPropertyCond twoCond = (TwoPropertyCond)cond;
			
			if (twoCond instanceof CondEqProperty) {
				return Restrictions.eqProperty(twoCond.getPropertyName(), twoCond.getOtherPropertyName());
			} else if (twoCond instanceof CondGeProperty) {
				return Restrictions.geProperty(twoCond.getPropertyName(), twoCond.getOtherPropertyName());
			} else if (twoCond instanceof CondGtProperty) {
				return Restrictions.gtProperty(twoCond.getPropertyName(), twoCond.getOtherPropertyName());
			} else if (twoCond instanceof CondLeProperty) {
				return Restrictions.leProperty(twoCond.getPropertyName(), twoCond.getOtherPropertyName());
			} else if (twoCond instanceof CondLtProperty) {
				return Restrictions.ltProperty(twoCond.getPropertyName(), twoCond.getOtherPropertyName());
			} else if (twoCond instanceof CondNeProperty) {
				return Restrictions.neProperty(twoCond.getPropertyName(), twoCond.getOtherPropertyName());
			}
			
		} else if (cond instanceof PropertyValuesCond) {
			PropertyValuesCond valuesCond = (PropertyValuesCond)cond;
			if (valuesCond instanceof CondBetween) {
				CondBetween betCond = (CondBetween)valuesCond;
				
				return Restrictions.between(valuesCond.getPropertyName(),
						betCond.getLo(), betCond.getHi());
			} else if (valuesCond instanceof CondIn) {
				return Restrictions.in(valuesCond.getPropertyName(), valuesCond.getValues());
			} else if (valuesCond instanceof CondNotIn) {
				return Restrictions.not(
						Restrictions.in(valuesCond.getPropertyName(), valuesCond.getValues())
						);
			}
			
		} else if (cond instanceof PropertyCond) {
			PropertyCond propertyCond = (PropertyCond)cond;
			
			if (propertyCond instanceof CondEmpty) {
				return Restrictions.isEmpty(propertyCond.getPropertyName());
			} else if (propertyCond instanceof CondNotEmpty) {
				return Restrictions.isNotEmpty(propertyCond.getPropertyName());
			} else if (propertyCond instanceof CondNotNull) {
				return Restrictions.isNotNull(propertyCond.getPropertyName());
			} else if (propertyCond instanceof CondNull) {
				return Restrictions.isNull(propertyCond.getPropertyName());
			}
			
		}
		throw new IllegalArgumentException("not supported Cond type : "+cond.getClass().getName());
	}

	/**
	 * crit   ߰Ѵ.
	 *  
	 * @param crit
	 * @param filter
	 */
	public void appendOrder(Criteria crit, SearchFilter filter) {
		List orders = filter.getOrders();
		for (int i = 0 ; i < orders.size() ; i++) {
			Order order = (Order)orders.get(i);
			if (order.isAscending()) {
				crit.addOrder(org.hibernate.criterion.Order.asc(order.getPropertyName()));
			} else {
				crit.addOrder(org.hibernate.criterion.Order.desc(order.getPropertyName()));
			}
		}
	}
}
