/*
 * Ʈ: TLE2Framework
 * ϸ: StringValueTag.java
 * ۼ: 2005. 09. 16
 */
package tle.framework.component.impl.uicreator.customtag;

import java.io.IOException;

import javax.servlet.jsp.JspException;
import javax.servlet.jsp.tagext.TagSupport;

import tle.framework.component.impl.uicreator.DefaultUICreator;
import tle.framework.component.impl.uicreator.config.ViewConfig;

/**
 * JSP   Ͽ  ڿ  ϱ ؼ Ǵ Ŀ ±.
 * <p>
 * JSP 1.2  ϴ Ŭ-Ÿ Ŀ ±̴. 
 * 
 * @author ֹ
 * @since 2.0.5.7
 */
public class StringValueTag extends TagSupport {
	private String name;
	
	public void setName(String name) {
		this.name = name;
	}
	
	/**
	 * request ̸ DefaultUICreator.VIEW_CONFIG_ATTRIBUTE_NAME  Ӽ
	 *  ViewConfig ü о ViewConfig.getStringValue()   Ѵ.
	 * ̶ ViewConfig.getSubpage() ޼ҵ ڰ
	 * setName() ޼ҵ带 ؼ Է¹ ̴. 
	 * 
	 * @see javax.servlet.jsp.tagext.Tag#doStartTag()
	 */
	public int doStartTag() throws JspException {
		ViewConfig viewConfig = (ViewConfig)pageContext.getRequest().getAttribute(DefaultUICreator.VIEW_CONFIG_ATTRIBUTE_NAME);
		String value = viewConfig.getStringValue(name);
		try {
			if (value != null) {
				pageContext.getOut().print(value);
			}
			return SKIP_BODY;
		} catch (IOException e) {
			throw new JspException(e);
		} finally {
			name = null;
		}
	}
}
