/*
 * Ʈ: TLE2Framework
 * ϸ: RPHttpServletResponseWrapper.java
 * ۼ: 2005. 6. 8
 */
package tle.framework.component.impl.rp.http;

import java.io.IOException;
import java.io.PrintWriter;

import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpServletResponseWrapper;

/**
 * JSPCommandHandler Ǵ HttpServletResponseWrapper.
 * <p>
 *  ۸ ޹ α׷ response.getOutputStream()  getWriter() 
 * ؼ    response  ʴ´.
 * <p>
 * , setIgnoreContentType(true) ϸ,
 * response.setContentType() ȣϴ  response  ʴ´.
 *  
 * @author ֹ
 * @since 2.0.5.6
 */
public class RPHttpServletResponseWrapper extends HttpServletResponseWrapper {
	
	private boolean ignoreContentType = false;
	
	private ServletOutputStream outputStream = null;
	private PrintWriter writer = null;
	
	/**
	 * @param response
	 */
	public RPHttpServletResponseWrapper(HttpServletResponse response) {
		super(response);
		initWriter();
	}
	
	private void initWriter() {
		outputStream = new RPServletOutputStream();
		writer = new PrintWriter(outputStream);
	}
	
	/**
	 * ignoreContentType ʵ  Ѵ.
	 * <p>
	 *   true ϸ response.setContentType() ޼ҵ带 ȣ 
	 *  response setContentType() ޼ҵ带 ȣ ʴ´. 
	 * @param ignore
	 */
	public void setIgnoreContentType(boolean ignore) {
		this.ignoreContentType = ignore;
	}
	
	public ServletOutputStream getOutputStream() throws IOException {
		return outputStream;
	}
	
	public PrintWriter getWriter() throws IOException {
		return writer;
	}
	
	/**
	 * ignoreContentType ʵ  true̸  response.setContentType() ޼ҵ带
	 * ȣ ʴ´.
	 * 
	 * @contentType Ÿ
	 */
	public void setContentType(String contentType) {
		if (!ignoreContentType) {
			super.setContentType(contentType);
		} else {
			// Ʈ Ÿ  
		}
	}
}
