/*
 * Ʈ: TLE2Framework
 * ϸ: DefaultResult.java
 * ۼ: 2004. 10. 22
 */
package tle.framework.component.impl.rp;

import java.util.Iterator;
import java.util.List;
import java.util.Map;

import javax.servlet.ServletContext;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpSession;
import javax.servlet.jsp.PageContext;

import tle.framework.component.spi.ra.RequestInfo;
import tle.framework.component.spi.rp.Result;

/**
 * Result  Ŭ.
 * 
 * @author ֹ
 * @since 2.0
 */
public class DefaultResult implements Result {
	
	/**
	 * ɾ ID
	 */
	private String commandID;
	/**
	 *  ڵ带 Ѵ.
	 */
	private String code;
	/**
	 * UI  ͸ Ѵ.
	 */
	private Map dataMap;
	/**
	 *  ߻ߴ  θ Ÿ.
	 */
	private boolean errorOccured;
	/**
	 * ڵ鷯 û óϴ  ߻  ü Ѵ.
	 */
	private Throwable exception;
	/**
	 *  ޽  ϴ Ʈ
	 */
	private List errorMessageList;
	/**
	 * Result  RequestInfo
	 */
	private RequestInfo requestInfo;
	
	/**
	 *   ɾID ޹޴´.
	 * 
	 * @param commandID
	 */
	public DefaultResult(String commandID) {
		this.commandID = commandID;
		errorOccured = false;
	}
	
	/**
	 * @see tle.framework.component.spi.rp.Result#getCommandID()
	 */
	public String getCommandID() {
		return commandID;
	}
	
	/**
	 *  ڵ带 Ѵ.
	 * @param code
	 */
	public void setCode(String code) {
		this.code = code;
	}
	
	/**
	 * setCode() ޹  ڵ带 Ѵ.
	 * 
	 * @see tle.framework.component.spi.rp.Result#getCode()
	 */
	public String getCode() {
		return code;
	}
	
	/**
	 * &lt;name, value>  Ѵ.
	 *  
	 * @param name
	 * @param value
	 */
	public void setData(String name, Object value) {
		if (dataMap == null) {
			dataMap = new java.util.HashMap();
		}
		dataMap.put(name, value);
	}
	
	/**
	 * dataMapκ name شϴ  Ѵ.
	 * 
	 * @see tle.framework.component.spi.rp.Result#getData(java.lang.String)
	 */
	public Object getData(String name) {
		if (dataMap == null) return null;
		return dataMap.get(name);
	}
	
	public void copyDataTo(HttpSession session) {
		if (dataMap == null) return;
		Iterator keySet = dataMap.keySet().iterator();
		while(keySet.hasNext()) {
			String key = (String)keySet.next();
			Object value = dataMap.get(key);
			session.setAttribute(key, value);
		}
	}

	public void copyDataTo(PageContext page) {
		if (dataMap == null) return;
		Iterator keySet = dataMap.keySet().iterator();
		while(keySet.hasNext()) {
			String key = (String)keySet.next();
			Object value = dataMap.get(key);
			page.setAttribute(key, value);
		}
	}

	public void copyDataTo(ServletContext application) {
		if (dataMap == null) return;
		Iterator keySet = dataMap.keySet().iterator();
		while(keySet.hasNext()) {
			String key = (String)keySet.next();
			Object value = dataMap.get(key);
			application.setAttribute(key, value);
		}
	}

	public void copyDataTo(ServletRequest request) {
		if (dataMap == null) return;
		Iterator keySet = dataMap.keySet().iterator();
		while(keySet.hasNext()) {
			String key = (String)keySet.next();
			Object value = dataMap.get(key);
			request.setAttribute(key, value);
		}
	}

	/**
	 *  ߻ߴ θ Ѵ.
	 * 
	 * @param b
	 */
	public void setErrorOccured(boolean b) {
		errorOccured = b;
	}
	
	/**
	 * @see tle.framework.component.spi.rp.Result#isErrorOccured()
	 */
	public boolean isErrorOccured() {
		return errorOccured;
	}
	
	/**
	 * û óϴ  ߻ ܸ Ѵ. 
	 * @param e
	 */
	public void setException(Throwable e) {
		this.exception = e;
	}
	
	/**
	 * setException() ޼ҵ   ü Ѵ.
	 * @see tle.framework.component.spi.rp.Result#getException()
	 */
	public Throwable getException() {
		return exception;
	}
	
	/**
	 *  ޽ ߰Ѵ.
	 * @param messsage
	 */
	public void addErrorMessage(String message) {
		if (errorMessageList == null) {
			errorMessageList = new java.util.ArrayList(4);
		}
		errorMessageList.add(message);
	}
	
	/**
	 * addErrorMessage() ޼ҵ ߰  ޽ 迭 Ѵ.
	 *    ̰ null Ѵ.
	 * @see tle.framework.component.spi.rp.Result#getErrorMessage()
	 */
	public String[] getErrorMessage() {
		if (errorMessageList == null) return null;
		String[] errorMessageArray = new String[errorMessageList.size()];
		errorMessageList.toArray(errorMessageArray);
		return errorMessageArray;
	}
	
	/**
	 * DefaultRequestProcessor.process() ޼ҵ忡 CommandHandler.process()
	 * ޼ҵ忡 ϱ   ޼ҵ带 ȣؼ DefaultResult RequestInfo Ѵ.
	 *  
	 * @param requestInfo
	 */
	void setRequestInfo(RequestInfo requestInfo) {
		this.requestInfo = requestInfo;
	}
	
	/**
	 * @see tle.framework.component.spi.rp.Result#getRequestInfo()
	 */
	public RequestInfo getRequestInfo() {
		return requestInfo;
	}
}
