package tle.searchutil;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

/**
 * ˻    Ǵ .
 *  
 * @author ֹ
 */
public class SearchFilter {
	private List conds;
	private List orders;
	
	public SearchFilter() {
	}
	
	public SearchFilter insertCond(int idx, Cond cond) {
		if (conds == null) conds = new ArrayList(10);
		conds.add(idx, cond);
		
		return this;
	}
	
	public SearchFilter addCond(Cond cond) {
		if (conds == null) conds = new ArrayList(10);
		conds.add(cond);
		
		return this;
	}
	
	public List getConds() {
		if (conds == null) return Collections.EMPTY_LIST;
		return conds;
	}
	
	public int sizeConds() {
		if (conds == null) return 0;
		return conds.size();
	}
	
	public boolean hasConds() {
		return conds != null && conds.size() > 0;
	}

	public SearchFilter addOrder(Order order) {
		if (orders == null) orders = new ArrayList(4);
		orders.add(order);
		return this;
	}

	public List getOrders() {
		if (orders == null) return Collections.EMPTY_LIST; 
		return orders;
	}

	public boolean hasOrders() {
		return orders != null && orders.size() > 0;
	}
	
	public int sizeOrders() {
		if (orders == null) return 0;
		return orders.size();
	}
}
