/*
 * Ʈ: TLE2Framework
 * ϸ: UIConfiguration.java
 * ۼ: 2004. 10. 29
 */
package tle.framework.component.impl.uicreator.config;

import java.net.URL;
import java.util.List;
import java.util.Map;

import org.apache.commons.digester.Digester;
import org.apache.commons.digester.xmlrules.DigesterLoader;

import tle.framework.log.Logger;
import tle.framework.util.TLEConfigPathUtil;

/**
 *  Ͽ   Ѵ.
 * 
 * @author ֹ
 * @since 2.0
 */
public class UIConfiguration {
	/**
	 * ViewSetConfig 
	 */
	private Map viewSetConfigMap = new java.util.HashMap();
	/**
	 * global-result-mapping ± prefix Ӽ  
	 */
	private String globalResultPrefix;
	/**
	 * global 並  prefix ߴ θ  
	 */
	private Boolean hasGlobalResultPrefix;
	/**
	 * &lt;global-result-mapping> result ±  Ѵ.
	 * result ± code Ű view  Ѵ.
	 */
	private Map globalResultConfigMap = new java.util.HashMap();
	/**
	 * CommandConfig 
	 */
	private Map commandConfigMap = new java.util.HashMap();
	/**
	 * client-view-set ± default-view-set Ӽ  
	 */
	private String defaultViewSetID;
	/**
	 * ClientConfig 
	 */
	private Map clientMap = new java.util.HashMap();
	
	/**
	 * @param viewSetConfig
	 * @throws IllegalArgumentException ̹  ViewSetID شϴ ViewSetConfig ϵ  ߻Ѵ.
	 */
	public void addViewSetConfig(ViewSetConfig viewSetConfig) {
		if (viewSetConfigMap.containsKey(viewSetConfig.getViewSetID())) {
			throw new IllegalArgumentException("aleady exists ViewSetConfig: [viewSetID="+viewSetConfig.getViewSetID()+"]"); 
		}
		viewSetConfigMap.put(viewSetConfig.getViewSetID(), viewSetConfig);
	}
	public ViewSetConfig getViewSetConfig(String viewSetID) {
		return (ViewSetConfig)viewSetConfigMap.get(viewSetID);
	}
	public void setGlobalResultPrefix(String globalPrefix) {
		this.globalResultPrefix = globalPrefix;
		
		if (globalResultPrefix != null && globalResultPrefix.length() > 0) 
			hasGlobalResultPrefix = Boolean.TRUE;
		else
			hasGlobalResultPrefix = Boolean.FALSE;
	}
	public boolean hasGlobalResultPrefix() {
		if (hasGlobalResultPrefix == null) {
			hasGlobalResultPrefix = Boolean.FALSE;
		}
		return hasGlobalResultPrefix.booleanValue();
	}
	/**
	 *  ڵ尡 global prefix   true
	 * @param code
	 * @return code null̸ false, global prefix  false, code ̿ global preifx ̰ Ƶ false
	 */
	public boolean checkGlobalResultPrefix(String code) {
		if (code == null) return false;
		if (hasGlobalResultPrefix()) {
			if (code.length() == globalResultPrefix.length()) return false;
			return code.startsWith(globalResultPrefix);
		} else {
			return false;
		}
	}
	public String getGlobalResultPrefix() {
		return this.globalResultPrefix;
	}
	/**
	 * @param code
	 * @param viewID
	 * @throws IllegalArgumentException Է code ̹ ϴ  ߻Ѵ
	 */
	public void addGlobalResultMapping(String code, String viewID) {
		if (globalResultConfigMap.containsKey(code)) {
			throw new IllegalArgumentException("aleady exists GlobalResultMap: [code, viewID]:["+code+","+viewID+"]");
		}
		globalResultConfigMap.put(code, viewID);
	}
	public String getGlobalResultMapping(String code) {
		return (String)globalResultConfigMap.get(code);
	}
	/**
	 * @param commandConfig
	 * @throws IllegalArgumentException ̹  CommandID شϴ CommandConfig ϵ  ߻Ѵ. 
	 */
	public void addCommandConfig(CommandConfig commandConfig) {
		if (commandConfigMap.containsKey(commandConfig.getCommandID())) {
			throw new IllegalArgumentException("aleady exists CommandConfig: commandID=["+commandConfig.getCommandID()+"]");
		}
		commandConfigMap.put(commandConfig.getCommandID(), commandConfig);
	}
	public void loadCommandMapping(String file) {
		try {
			URL ruleXml = UIConfigurationDigester.class.getClassLoader().getResource("tle/framework/component/impl/uicreator/config/UIConfiguration.cm.rule.xml");
			Digester digester = DigesterLoader.createDigester(ruleXml);
			List list = (List)digester.parse(TLEConfigPathUtil.replace(file));
			for (int i = 0 ; i < list.size() ; i++) {
				CommandConfig commandConfig = (CommandConfig)list.get(i);
				addCommandConfig(commandConfig);
			}
		} catch(Throwable e) {
			Logger.error("UIConfiguration.loadCommandMapping():"+e.getMessage(), e);
		}
	}
	public CommandConfig getCommandConfig(String commandID) {
		return (CommandConfig)commandConfigMap.get(commandID);
	}
	public void setDefaultViewSet(String viewSetID) {
		this.defaultViewSetID = viewSetID;
	}
	public ViewSetConfig getDefaultViewSetConfig() {
		return (ViewSetConfig)viewSetConfigMap.get(defaultViewSetID);
	}
	public void addClient(String clientType, String viewSetID) {
		clientMap.put(clientType, viewSetID);
	}
	public ViewSetConfig getClientViewSetConfig(String clientType) {
		String viewSetID = (String)clientMap.get(clientType);
		ViewSetConfig viewSet = (ViewSetConfig)viewSetConfigMap.get(viewSetID);
		if (viewSet == null) {
			viewSet = getDefaultViewSetConfig();
		}
		return viewSet;
	}
}
