/*
 * Ʈ: TLE2Framework
 * ϸ: ServiceManagerConfigurationDigester.java
 * ۼ: 2004. 11. 10
 */
package tle.framework.component.impl.aamanager.service;

import java.io.File;
import java.io.IOException;
import java.net.URL;

import org.apache.commons.digester.Digester;
import org.apache.commons.digester.xmlrules.DigesterLoader;
import org.xml.sax.SAXException;

/**
 *   Ϸκ ͸ о ServiceManagerConfiguration ü ϴ Ŭ. 
 *  
 * @author ֹ
 * @since 2.0 
 */
public class ServiceManagerConfigurationDigester {
	private static Digester digester = null;
	
	public static ServiceManagerConfiguration create(String filePath) throws IOException, SAXException {
		if (digester == null) {
			ServiceManagerConfigurationDigester.initDigester();
		}
		File configFile = new File(filePath);
		ServiceManagerConfiguration configuration = (ServiceManagerConfiguration)digester.parse(configFile);
		return configuration;
	}
	
	private static void initDigester() {
		synchronized(ServiceManagerConfigurationDigester.class) {
			if (digester == null) {
				URL ruleXml = ServiceManagerConfigurationDigester.class.getClassLoader().getResource("tle/framework/component/impl/aamanager/service/ServiceManagerConfiguration.rule.xml");
				digester = DigesterLoader.createDigester(ruleXml);
			}
		}
	}
	
}
