/*
 * Ʈ: TLE2Framework
 * ϸ: AAManager.java
 * ۼ: 2004. 10. 19
 */
package tle.framework.component.spi.aamanager;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import tle.framework.component.Component;
import tle.framework.component.spi.ra.RequestInfo;

/**
 *   óϴ Ʈ  Ѵ.
 * <p>
 *   񽺸  Ʈ  ̽ ־ Ѵ.
 * 
 * @author ֹ
 * @since 2.0
 */
public interface AAManager extends Component {

	/**
	 * UserAuthenticationInfo   Ͽ    ڿ شϴ User ü Ѵ.
	 * 
	 * @param authInfo   
	 * @return     User 
	 * @throws AuthenticationException ̵ ȣ ߸     쿡 ߻Ѵ.
	 * @throws AAManagerException Ÿ    ߻Ѵ. 
	 */
	public User authenticate(UserAuthenticationInfo authInfo)
			throws AAManagerException;

	/**
	 *   Ѵ.
	 * <p>
	 * AAManager ü HttpSession̳ Ÿ ٸ  ؼ  ־ Ѵ.
	 * 
	 * @param user ǿ  
	 * @param request HTTP û
	 * @param response HTTP 
	 */
	public void openSession(User user, HttpServletRequest request,
			HttpServletResponse response) throws AAManagerException;

	/**
	 *   Ѵ.
	 */
	public void closeSession(HttpServletRequest request,
			HttpServletResponse response) throws AAManagerException;

	/**
	 * ǰ õ User Ѵ.  ۵ ʾҴٸ NullUser Ѵ.
	 * 
	 * @param request
	 * @return ǿ  User.  ۵ ʾҴٸ NullUser .
	 */
	public User getSessionUser(HttpServletRequest request)
			throws AAManagerException;

	/**
	 * user service     true Ѵ.
	 * 
	 * @param user 
	 * @param service 
	 * @return
	 */
	public boolean checkAuthorization(User user, Service service)
			throws AAManagerException;

	/**
	 * û  شϴ Service Ѵ.  񽺰    NullService Ѵ.
	 * 
	 * @param requestInfo û 
	 * @return Service
	 */
	public Service getService(RequestInfo requestInfo)
			throws AAManagerException;
	
	/**
	 *  ID شϴ  Ѵ.    null Ѵ.
	 * 
	 * @param roleID  ID
	 * @return Role
	 * @throws AAManagerException
	 */
	public Role getRole(String roleID) throws AAManagerException;
	
	/**
	 *  AAManager ü  AAManagerProxy Ѵ.
	 * Ʋ ӿũ ϴ ýۿ AAManager ϴ ɵ ϱ ؼ
	 * AAManagerProxy ؼ  ϰ ȴ.
	 * <p>
	 *  , AAManager.openSession() ޼ҵ带 ϰ ʹٸ   ڵ带 ؾ Ѵ.
	 * <pre>
	 * 
	 *   TLEFramework.getAAManagerProxy().openSession(user, request, response);
	 * 
	 * </pre>
	 * 
	 * @return AAManagerProxy
	 * @see tle.framework.component.spi.aamanager.AAManagerProxy
	 */
	public AAManagerProxy getAAManagerProxy();
}