/*
 * Ʈ: TLE2Framework
 * ϸ: DefaultRequestAnalyzer.java
 * ۼ: 2004. 10. 21
 */
package tle.framework.component.impl.ra;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.apache.commons.fileupload.DiskFileUpload;
import org.apache.commons.fileupload.FileUpload;
import org.apache.commons.fileupload.FileUploadException;

import tle.framework.component.ComponentConfig;
import tle.framework.component.ComponentException;
import tle.framework.component.impl.ComponentBase;
import tle.framework.component.spi.ra.RequestAnalyzer;
import tle.framework.component.spi.ra.RequestAnalyzerException;
import tle.framework.component.spi.ra.RequestInfo;
import tle.framework.log.Logger;
import tle.framework.util.TLEConfigPathUtil;

/**
 * ɾ ID û URIκ Ѵ.
 * <p>
 * ε   Jakarta-Commons FileUpload API ؼ óѴ.
 * <p>
 * TLEFramework ʱ   "configFile" ʱȭ Ķͷ  Ϸκ ʱ   о´.
 *  "configFile" ʱȭ Ƽ  ʾ 쿡
 *  Ȩ 丮 "DefaultRequestAnalyzer.properties"  Ѵ.
 * <p>
 * ʱ      ʱⰪ   Ѵ.
 * <ul>
 *   <li>tempDir - "user.home" 
 *   <li>max - -1
 *   <li>encoding - ý ⺻ ڵ
 * </ul>
 * 
 * @author ֹ
 * @since 2.0 
 */
public class DefaultRequestAnalyzer extends ComponentBase implements
		RequestAnalyzer, DefaultRequestAnalyzerMBean {
	
	/**
	 * FileUpload API ε  ӽ÷ ϴ  
	 */
	private String tempDir;
	
	/**
	 * FileUpload API ε  ִ ũ
	 */
	private long max;
	
	/**
	 * FileUpload Ͽ Ķ͸ о   ڵ 
	 */
	private String encoding;

	/**
	 * DefaultRequestAnalyzer ʿ ϴ  ʱ  κ Ѵ.
	 * 
	 * @see tle.framework.component.impl.ComponentBase#initing(tle.framework.component.ComponentConfig)
	 */
	protected void initing(ComponentConfig config) throws ComponentException {
		String configFilePath = config.getInitParameter("configFile");
		if (configFilePath == null) {
			configFilePath = System.getProperty("user.home") + File.separator + "DefaultRequestAnalyzer.properties";
		}
		Properties properties = new Properties();
		File file = new File(TLEConfigPathUtil.replace(configFilePath));
		if (file.exists() && file.canRead()) {
			FileInputStream fis = null;
			try {
				fis = new FileInputStream(file);
				properties.load(fis);
				tempDir = properties.getProperty("tempDir");
				try {
					String maxStr = properties.getProperty("max");
					if (maxStr != null) {
						maxStr = maxStr.trim();
						if (maxStr.length() > 0) {
							char lastCh = maxStr.charAt(maxStr.length() - 1);
							String value = null;
							
							long multi = 1L;
							if (lastCh == 'k' || lastCh == 'K') {
								multi = 1024L; // 1K
								value = maxStr.substring(0, maxStr.length() - 1);
							} else if (lastCh == 'm' || lastCh == 'M') {
								multi = 1024L * 1024L; // 1K * 1024 , 1M
								value = maxStr.substring(0, maxStr.length() - 1);
							} else if (lastCh == 'g' || lastCh == 'M') {
								multi = 1024L * 1024L * 1024L; // 1M
								value = maxStr.substring(0, maxStr.length() - 1);
							} else {
								value = maxStr;
							}
							max = multi * Long.parseLong(value);
						}
					}
				} catch(Throwable t) {
					if (Logger.isWarnEnabled()) {
						Logger.warn("DefaultRequestAnalyzer.initing():invalid max property value="+properties.getProperty("max"), t);
					}
					max = -1L;
				}
				encoding = properties.getProperty("encoding");
			} catch(IOException ex) {
				//   о   ߻ϴ Ʈ ʱȭ ȴ.
				if (Logger.isWarnEnabled()) {
					Logger.warn("DefaultRequestAnalyzer.initing():Property File Loading Error", ex);
				}
			} finally {
				if (fis != null) try { fis.close(); } catch(IOException ex) {}
			}
		} else {
			tempDir = System.getProperty("user.home");
			max = -1L;
			encoding = properties.getProperty("file.encoding");
		}
	}
	
	/**
	 * Jakarta Commons FileUpload API FileUpload.isMultipartContent(request) Ͽ
	 * ڵ Ÿ multipart/form-data ̸ FileUpload API ؼ RequestInfo νϽ Ѵ.
	 * <p>
	 * ؽƮ κ θ   κ ɾ ID Ѵ.
	 *  
	 * @see tle.framework.component.spi.ra.RequestAnalyzer#analyzeRequest(javax.servlet.http.HttpServletRequest, javax.servlet.http.HttpServletResponse)
	 */
	public RequestInfo analyzeRequest(HttpServletRequest request, HttpServletResponse response) throws RequestAnalyzerException {
		DefaultRequestInfo requestInfo = new DefaultRequestInfo(request, response);
		String characterEncoding = encoding;
		if (characterEncoding == null) {
			characterEncoding = request.getCharacterEncoding();
		}
		
		if (FileUpload.isMultipartContent(request)) {
			DiskFileUpload fileUpload = new DiskFileUpload();
			fileUpload.setSizeMax(max);
			fileUpload.setRepositoryPath(this.tempDir);
			fileUpload.setHeaderEncoding(characterEncoding);
			try {
				List itemList = fileUpload.parseRequest(request);
				java.util.Map paramMap = new java.util.HashMap();
				
				for (int i = 0 ; i < itemList.size() ; i++) {
					org.apache.commons.fileupload.FileItem item = (org.apache.commons.fileupload.FileItem) itemList.get(i);
					if (item.isFormField()) {
						String name = item.getFieldName();
						String value = null;
						try {
							value = item.getString(characterEncoding);
							
							List params = (List)paramMap.get(name);
							if (params == null) {
								params = new java.util.ArrayList(2);
								paramMap.put(name, params);
							}
							params.add(value);
						} catch (UnsupportedEncodingException e1) {
							throw new RequestAnalyzerException(e1.getMessage(), e1);
						}
					} else {
						DefaultFileItem fileItem = new DefaultFileItem();
						fileItem.init(item);
						requestInfo.addFileItem(fileItem.getParameterName(), fileItem);
					}
				}
				Iterator paramIter = paramMap.keySet().iterator();
				while (paramIter.hasNext()) {
					String paramName = (String)paramIter.next();
					List list = (List)paramMap.get(paramName);
					String[] values = new String[list.size()];
					list.toArray(values);
					
					requestInfo.addParameter(paramName, values);
				}
			} catch (FileUploadException e) {
				throw new RequestAnalyzerException(e.getMessage(), e);
			}
		} else {
			try {
				request.setCharacterEncoding(characterEncoding);
			} catch (UnsupportedEncodingException e) {
				throw new RequestAnalyzerException(e.getMessage(), e);
			}
			Enumeration enum = request.getParameterNames();
			while(enum.hasMoreElements()) {
				String name = (String)enum.nextElement();
				String[] values = request.getParameterValues(name);
				if (values != null) {
					requestInfo.addParameter(name, values);
				}
			}
		}
		String uri = request.getRequestURI();
		String contextPath = request.getContextPath();
		
		String commandID = null;
		if (contextPath.compareTo("") == 0) {
			commandID = uri;
		} else {
			commandID = uri.substring(contextPath.length());
		}
		requestInfo.setCommandID(commandID);
		return requestInfo;
	}

	public String getTempDir() {
		return tempDir;
	}

	public void setTempDir(String tempDir) {
		this.tempDir = tempDir;
	}

	public long getMax() {
		return max;
	}

	public void setMax(long max) {
		this.max = max;
	}

	public String getEncoding() {
		return encoding;
	}
	
	public void setEncoding(String encoding) {
		this.encoding = encoding;
	}
}
