/*
 * Ʈ: TLE2Framework
 * ϸ: ServiceManagerImpl.java
 * ۼ: 2004. 11. 10
 */
package tle.framework.component.impl.aamanager.service;

import java.io.IOException;
import java.util.List;
import java.util.Map;

import org.xml.sax.SAXException;

import tle.framework.component.ComponentConfig;
import tle.framework.component.impl.aamanager.ServiceManager;
import tle.framework.component.spi.aamanager.AAManagerException;
import tle.framework.component.spi.aamanager.NullService;
import tle.framework.component.spi.aamanager.Role;
import tle.framework.component.spi.aamanager.Service;
import tle.framework.component.spi.ra.RequestInfo;
import tle.framework.util.TLEConfigPathUtil;

/**
 * ServiceManager ü.
 * 
 * @author ֹ
 * @since 2.0
 */
public class ServiceManagerImpl implements ServiceManager {
	private Map serviceMap = new java.util.HashMap();
	private List serviceGroupList = null;
	private Map serviceGroupChainCacheMap = new java.util.HashMap();
	
	/**
	 * Ʈ "ServiceManagerImpl.configFile" ʱȭ Ķͷκ
	 *  ׷        θ Ѵ.
	 * 
	 * @see tle.framework.component.impl.aamanager.ServiceManager#init(tle.framework.component.ComponentConfig)
	 */
	public void init(ComponentConfig config) throws AAManagerException {
		loadConfiguration(config);
	}
	
	/**
	 * Ʈ "ServiceManagerImpl.configFile" ʱȭ Ķͷκ
	 *  ׷        θ Ѵ.
	 * <p>
	 * serviceGroupChainCacheMap  ĳ  Ѵ.
	 */
	private void loadConfiguration(ComponentConfig config) throws AAManagerException {
		String configFile = config.getInitParameter("ServiceManagerImpl.configFile");
		try {
			Map serviceMap = new java.util.HashMap();
			
			ServiceManagerConfiguration configuration = ServiceManagerConfigurationDigester.create(TLEConfigPathUtil.replace(configFile));
			List serviceList = configuration.getServiceList();
			for (int i = 0 ; i < serviceList.size() ; i++) {
				ServiceImpl service = (ServiceImpl)serviceList.get(i);
				serviceMap.put(service.getCommandID(), service);
			}
			
			this.serviceGroupList = configuration.getServiceGroupList();
			this.serviceGroupChainCacheMap.clear();
			this.serviceMap = serviceMap;
		} catch (IOException e) {
			throw new AAManagerException("ServiceManagerImpl.init(): б ", e);
		} catch (SAXException e) {
			throw new AAManagerException("ServiceManagerImpl.init(): б ", e);
		}
	}
	
	/**
	 *   ٽ о´.
	 * 
	 * @param config Ʈ ʱȭ 
	 * @throws AAManagerException
	 */
	public void reloadConfiguration(ComponentConfig config) throws AAManagerException {
		loadConfiguration(config);
	}
	
	/**
	 * û  ɾ ID شϴ Service Ѵ.
	 * ó   .
	 * <ol>
	 *    <li>serviceMap ɾ ID شϴ Service   ش Service Ѵ.</li>
	 *    <li> ǿ شϴ Service   ,
	 *       <ol>
	 *         <li> ɾ ID  ׷ü   ׷ü Ѵ.</li>
	 *       </ol>
	 *    <li>ƹ͵    NullService Ѵ.</li>
	 * </ol>
	 * @see tle.framework.component.impl.aamanager.ServiceManager#getService(tle.framework.component.spi.ra.RequestInfo)
	 */
	public Service getService(RequestInfo ri) {
		String commandID = ri.getCommandID();
		Service service = (Service)serviceMap.get(commandID);
		if (service == null) {
			service = (ServiceGroupChain)serviceGroupChainCacheMap.get(ri.getCommandID());
			if (service == null) {
				//  ׷ ü ĳø Ѵ.
				List groupChain = null;
				for (int i = 0 ; i < serviceGroupList.size() ; i++) {
					ServiceGroup group = (ServiceGroup)serviceGroupList.get(i);
					if (commandID.startsWith(group.getCommandPrefix()) ) {
						if (groupChain == null) {
							groupChain = new java.util.ArrayList();
						}
						groupChain.add(group);
					}
				}
				if (groupChain != null && groupChain.size() > 0) {
					// üο ԵǾ ִ  
					ServiceGroupChain serviceGroupChain = new ServiceGroupChain();
					serviceGroupChain.setCommandID(commandID);
					for (int i = 0 ; i < groupChain.size() ; i++) {
						serviceGroupChain.addServiceGroup((ServiceGroup)groupChain.get(i));
					}
					service = serviceGroupChain;
					serviceGroupChainCacheMap.put(
							serviceGroupChain.getCommandID(), serviceGroupChain);
				}
				// üο ԵǾ    NullService ȴ.
				if (service == null) {
					service = NullService.intance;
					serviceMap.put(commandID, service);
				}
			}
		}
		if (service == null) return NullService.intance;
		return service;
	}
	
	/**
	 * service   밡  true Ѵ.
	 * service NullService νϽ  true Ѵ.
	 * 
	 * @see tle.framework.component.impl.aamanager.ServiceManager#hasGrant(tle.framework.component.spi.aamanager.Role, tle.framework.component.spi.aamanager.Service)
	 */
	public boolean hasGrant(Role role, Service service) {
		if (service instanceof HasGrant) {
			return ((HasGrant)service).hasGrant(role);
		}
		if (service instanceof NullService) {
			return true;
		}
		return false;
	}

}
