/*
 * Ʈ: TLE2FrameworkExample
 * ϸ: UserManagerImpl.java
 * ۼ: 2004. 11. 15
 */
package test.tle.aamanager;

import test.tle.aamanager.UserRepository.UserDBRecord;
import tle.framework.TLEFramework;
import tle.framework.component.ComponentConfig;
import tle.framework.component.impl.aamanager.UserManager;
import tle.framework.component.spi.aamanager.AAManagerException;
import tle.framework.component.spi.aamanager.AAManagerProxy;
import tle.framework.component.spi.aamanager.Role;
import tle.framework.component.spi.aamanager.User;
import tle.framework.component.spi.aamanager.UserAuthenticationInfo;

/**
 * UserManager  Ŭ
 * 
 * @author ֹ
 */
public class UserManagerImpl implements UserManager {

	public void init(ComponentConfig config) throws AAManagerException {
		try {
			UserRepository.getInstance().init();
		} catch (Throwable e) {
			throw new AAManagerException("UserRepository ʱȭ   ߻", e);
		}
	}

	public User getUser(UserAuthenticationInfo userAuth) throws AAManagerException {
		UserAuthenticationInfoImpl userAuthImpl = (UserAuthenticationInfoImpl)userAuth;
		UserDBRecord userDB = UserRepository.getInstance().getUserDBRecord(userAuthImpl.getID());
		
		UserImpl user = new UserImpl();
		user.setID(userDB.getID());
		AAManagerProxy aaManagerProxy = TLEFramework.getAAManagerProxy();
		String[] roleIDs = userDB.getRoleIDs();
		for (int i = 0 ; i< roleIDs.length ; i++) {
			Role role = aaManagerProxy.getRole(roleIDs[i]);
			if (role != null) {
				user.addRole(role);
			}
		}
		
		return user;
	}

}
