/*
 * Ʈ: TLE2Framework
 * ϸ: CommandHandlerFactory.java
 * ۼ: 2004. 10. 22
 */
package tle.framework.component.impl.rp;

import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

import tle.framework.component.impl.rp.config.CommandMappingConfig;
import tle.framework.component.impl.rp.config.DefaultRPConfiguration;
import tle.framework.component.impl.rp.config.ValidatorConfig;
import tle.framework.component.impl.rp.handler.CommandHandler;
import tle.framework.component.impl.rp.handler.CommandHandlerClassLoader;
import tle.framework.component.impl.rp.handler.GoViewCommandHandler;
import tle.framework.component.impl.rp.handler.JSPCommandHandler;
import tle.framework.component.impl.rp.handler.NoHandlerCommandHandler;
import tle.framework.component.impl.rp.validator.Validator;
import tle.framework.component.spi.ra.RequestInfo;
import tle.framework.log.Logger;

/**
 * RequestProcessor Ǵ CommandHandler, Validator  Ѵ.
 *  û  شϴ HandlerConfig  ִ ɵ ִ.
 * 
 * @author ֹ
 * @since 2.0
 */
public class RequestProcessorElementFactory {
	
	private CommandHandlerClassLoader commandHandlerClassLoader;
	/**
	 * Validator Map
	 */
	private Map validatorMap;
	/**
	 * initHandlerInstance ޼ҵ忡  Map Ҵ
	 */
	private Map handlerMap;
	private Map commandHandlerMap;
	private CommandHandler defaultHandler = null;
	
	/**
	 * DefaultRPConfiguration &lt;ڵ鷯ID, ڵ鷯Ŭ>   о
	 * ڵ鷯 Ŭ νϽ Ѵ.
	 * <p>
	 *  Ŭ δ   CommandHandlerClassLoader  Ͽ 
	 * Ŭ νϽ Ѵ.
	 */
	public RequestProcessorElementFactory(DefaultRPConfiguration configuration) {
		if (configuration.isUsingIndependentClassPath()) {
			commandHandlerClassLoader = new CommandHandlerClassLoader(configuration.getClassPathArray());
		}
		init(configuration);
	}
	
	/**
	 * initHandler() ޼ҵ带 ȣϿ ڵ鷯  ϰ
	 * initCommandHandlerMapping() ޼ҵ带 ȣϿ ɾ ڵ鷯    ٽ Ѵ.
	 * 
	 * @param configuration  
	 */
	public void init(DefaultRPConfiguration configuration) {
		initValidator(configuration);
		initHandler(configuration);
		initCommandHandlerMapping(configuration);
	}
	
	/**
	 * Validator ʱȭѴ.
	 * 
	 * @param configuration
	 * @since 2.0.5
	 */
	private void initValidator(DefaultRPConfiguration configuration) {
		Map validatorMap = new java.util.HashMap();
		List validatorConfigList = configuration.getValidatorConfigList();
		for (int i = 0 ; i < validatorConfigList.size() ; i++) {
			ValidatorConfig validatorConfig = (ValidatorConfig)validatorConfigList.get(i);
			try {
				Class validatorClass = Class.forName(validatorConfig.getClassName());
				Validator validator = (Validator)validatorClass.newInstance();
				validatorMap.put(validatorConfig.getName(), validator);
			} catch (ClassNotFoundException e) {
				Logger.warn("fail to create Validator ("+validatorConfig.getName()+","+validatorConfig.getClassName()+")", e);
			} catch (InstantiationException e) {
				Logger.warn("fail to create Validator ("+validatorConfig.getName()+","+validatorConfig.getClassName()+")", e);
			} catch (IllegalAccessException e) {
				Logger.warn("fail to create Validator ("+validatorConfig.getName()+","+validatorConfig.getClassName()+")", e);
			} catch (ClassCastException e) {
				Logger.warn("fail to create Validator ("+validatorConfig.getName()+","+validatorConfig.getClassName()+")", e);
			}
		}
		this.validatorMap = validatorMap;
	}
	
	/**
	 *  ̸ Validator Ѵ.
	 * @param name
	 * @return    null Ѵ.
	 * @since 2.0.5
	 */
	public Validator createValitor(String name) {
		return (Validator)validatorMap.get(name);
	}
	
	/**
	 * ڵ鷯 ʱȭϴ  ޼ҵ带 ȣѴ.
	 * 
	 * @param configuration  
	 */
	private void initHandler(DefaultRPConfiguration configuration) {
		initHandlerInstance(configuration);
		initDefaultHandler(configuration);
	}
	
	/**
	 * &lt;ڵ鷯ID, ڵ鷯νϽ>  ʱȭѴ.
	 * 
	 * @param configuration  
	 */
	private void initHandlerInstance(DefaultRPConfiguration configuration) {
		Map handlerMap = new java.util.HashMap();
		Map handlerClassMap = configuration.getHandlerClassMap();
		Iterator iter = handlerClassMap.keySet().iterator();
		while (iter.hasNext()) {
			String handlerID = (String)iter.next();
			String className = (String)handlerClassMap.get(handlerID);
			try {
				Class handlerClass = null;
				if (commandHandlerClassLoader != null) {
					handlerClass = commandHandlerClassLoader.loadHandlerClass(className); 
				} else {
					handlerClass = Class.forName(className);
				}
				CommandHandler handler = (CommandHandler)handlerClass.newInstance();
				handlerMap.put(handlerID, handler);
			} catch (ClassNotFoundException e) {
				Logger.warn("fail to create Handler ("+handlerID+","+className+")", e);
			} catch (InstantiationException e) {
				Logger.warn("fail to create Handler ("+handlerID+","+className+")", e);
			} catch (IllegalAccessException e) {
				Logger.warn("fail to create Handler ("+handlerID+","+className+")", e);
			} catch (ClassCastException e) {
				Logger.warn("fail to create Handler ("+handlerID+","+className+")", e);
			}
		}
		Map handlerJspMap = configuration.getHandlerJspMap();
		Iterator iterJsp = handlerJspMap.keySet().iterator();
		while(iterJsp.hasNext()) {
			String handlerID = (String)iterJsp.next();
			String jspPage = (String)handlerJspMap.get(handlerID);
			CommandHandler handler = new JSPCommandHandler(jspPage);
			handlerMap.put(handlerID, handler);
		}
		
		this.handlerMap = handlerMap;
	}
	
	/**
	 * ⺻ ڵ鷯 Ѵ.
	 * 
	 * @param configuration  
	 */
	private void initDefaultHandler(DefaultRPConfiguration configuration) {
		GoViewCommandHandler goViewHandler = new GoViewCommandHandler();
		NoHandlerCommandHandler noHandler = new NoHandlerCommandHandler();
		
		switch(configuration.getDefaultHandlerType()) {
			case DefaultRPConfiguration.DEFAULT_GOVIEW:
				defaultHandler = goViewHandler;
				break;
			case DefaultRPConfiguration.DEFAULT_NOHANDLER:
				defaultHandler = noHandler;
				break;
		}
		
		handlerMap.put("default.GOVIEW", goViewHandler);
		handlerMap.put("default.NOHANDLER", noHandler);
	}
	
	/**
	 * &lt;ɾID, ڵ鷯ID>   Ѵ.
	 * 
	 * @param configuration  
	 */
	private void initCommandHandlerMapping(DefaultRPConfiguration configuration) {
		commandHandlerMap = Collections.unmodifiableMap(configuration.getCommandHandlerMap());
	}
	
	/**
	 * û  ˸ CommandMappingConfig Ѵ.
	 *    null Ѵ.
	 * 
	 * @param requestInfo
	 * @return
	 * @since 2.0.5
	 */
	public CommandMappingConfig createCommandMappingConfig(RequestInfo requestInfo) {
		return (CommandMappingConfig)commandHandlerMap.get(requestInfo.getCommandID());
	}
	
	/**
	 * û  ˸ CommandHandler Ѵ.
	 *  û  شϴ CommandHandler ٸ
	 * ⺻ڵ鷯 Ѵ. (⺻ ڵ鷯  Ͽ Ѵ.
	 * 
	 * @param requestInfo
	 * @return û  شϴ ɾ ڵ鷯
	 */
	public CommandHandler createCommandHandler(RequestInfo requestInfo) {
		CommandMappingConfig commandMapping = (CommandMappingConfig)commandHandlerMap.get(requestInfo.getCommandID());
		if (commandMapping == null) {
			// Ŀǵ  ٸ ⺻ ڵ鷯
			return defaultHandler;
		}
		CommandHandler handler = (CommandHandler)handlerMap.get(commandMapping.getHandlerID());
		if (handler == null) {
			return defaultHandler;
		}
		return handler;
	}
	
	/**
	 * ڵ鷯 Ŭ εѴ.
	 * <p>
	 * , CommandHandlerClassLoader Ŭδ ϴ 쿡 
	 * ڵ鷯 Ŭ ε ϴ.
	 * <p>
	 * ڵ鷯 Ŭ ε   Ŭδ Ӱ ϰ,
	 *  ڿ initHandler() ޼ҵ带 ȣѴ.
	 * 
	 * @param configuration  
	 * @throws UnsupportedOperationException ڵ鷯 ε  ʴ 쿡 ߻Ѵ.
	 */
	public void reloadHandlerClasses(DefaultRPConfiguration configuration) {
		if (this.commandHandlerClassLoader != null) {
			commandHandlerClassLoader.remakeClassLoader();
			initHandler(configuration);
		} else {
			throw new UnsupportedOperationException("ClassLoader != CommandHandlerClassLoader");
		}
	}
}
