/*
 * Ʈ: TLE2Framework
 * ϸ: TLEController.java
 * ۼ: 2004. 10. 14
 */
package tle.framework;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import tle.framework.component.ComponentException;
import tle.framework.component.impl.ComponentBase;
import tle.framework.component.spi.aamanager.AAManager;
import tle.framework.component.spi.aamanager.NullUser;
import tle.framework.component.spi.aamanager.Service;
import tle.framework.component.spi.aamanager.User;
import tle.framework.component.spi.ra.RequestAnalyzer;
import tle.framework.component.spi.ra.RequestAnalyzerException;
import tle.framework.component.spi.ra.RequestInfo;
import tle.framework.component.spi.ra.RequestInfoWrapper;
import tle.framework.component.spi.rp.RequestProcessor;
import tle.framework.component.spi.rp.Result;
import tle.framework.component.spi.uicreator.UICreator;
import tle.framework.http.RIRequestWrapper;
import tle.framework.log.Logger;

/**
 * Ŭ̾Ʈ û   ھ Ʈ Ͽ ˸° óִ Ʈѷ̴.
 * <p>
 * TLEController Ʋ ӿũ ϵǴ Ʈ̴. 
 * 
 * @author ֹ
 * @since 2.0
 */
public class TLEController extends ComponentBase implements TLEControllerMBean {
	/**
	 * û мⰡ  RequestInfoκ Ķ  о
	 * RIRequestWrapper RequestProcessor, UICreator  θ
	 * Ÿ.
	 */
	private boolean useWrapper = false; 
	
	private RequestAnalyzer ra;
	private RequestProcessor rp;
	private AAManager aaManager;
	private UICreator uiCreator;
	
	/**
	 * aaManager Ѵ.
	 * 
	 * @return
	 */
	AAManager getAAManager() {
		return aaManager;
	}
	
	void setUseWrapper(boolean useWrapper) {
		this.useWrapper = useWrapper;
	}
	
	public boolean isUseWrapper() {
		return useWrapper;
	}
	
	/**
	 * @see tle.framework.TLEControllerMBean#getRequestAnalyzerName()
	 */
	public String getRequestAnalyzerID() {
		return ra.getID();
	}

	/**
	 * @see tle.framework.TLEControllerMBean#getRequestProcessorName()
	 */
	public String getRequestProcessorID() {
		return rp.getID();
	}

	/**
	 * @see tle.framework.TLEControllerMBean#getAAmanagerName()
	 */
	public String getAAmanagerID() {
		return aaManager.getID();
	}

	/**
	 * @see tle.framework.TLEControllerMBean#getUICreatorName()
	 */
	public String getUICreatorID() {
		return uiCreator.getID();
	}
	
	/**
	 * 4 ھ Ʈ Ѵ.
	 * 
	 * @param ra
	 * @param rp
	 * @param aaManager
	 * @param uiCreator
	 * @throws IllegalArgumentException 4 ٽ Ʈ  ϳ  ʾ 쿡 ߻
	 */
	void setCoreComponents(RequestAnalyzer ra, RequestProcessor rp, AAManager aaManager, UICreator uiCreator) {
		if (ra == null) throw new IllegalArgumentException("RequestAnalyzer == null");
		if (rp == null) throw new IllegalArgumentException("RequestProcessor == null");
		if (aaManager == null) throw new IllegalArgumentException("AAManager == null");
		if (uiCreator == null) throw new IllegalArgumentException("UICreator == null");
		
		this.ra = ra;
		this.rp = rp;
		this.aaManager = aaManager;
		this.uiCreator = uiCreator;
	}
	
	/**
	 * ϰ ִ 4 ھ Ʈ  ۷ Ѵ.
	 *  
	 * @see tle.framework.component.impl.ComponentBase#closing()
	 */
	protected void closing() throws ComponentException {
		if (ra != null) ra = null;
		if (rp != null) rp = null;
		if (aaManager != null) aaManager = null;
		if (uiCreator != null) uiCreator = null;
	}

	/**
	 * "TLEController" Ѵ.
	 * 
	 * @see tle.framework.component.Component#getID()
	 */
	public String getID() {
		return "TLEController";
	}
	
	public String getDescription() {
		return "TLEController";
	}
	
	/**
	 * ھ Ʈ Ͽ Ŭ̾Ʈ û óѴ.
	 * <p>
	 * ó   .
	 * <ol>
	 *    <li>RequestAnalyzer Ͽ Ŭ̾Ʈ û(RequestInfo) Ѵ.</li>
	 *    <li>AAManager Ͽ   (User) Ѵ.</li>
	 *    <li>AAManager Ͽ û شϴ (Service) Ѵ.</li>
	 *    <li>񽺰  ʿ ϴ  
	 *        <ul>
	 *           <li>α   α  ̵Ѵ.</li>
	 *           <li>α  񽺸   ִ  ˻Ѵ.</li>
	 *           <li>񽺸    Ѿ  ش.</li>
	 *        </ul>
	 *    </li>
	 *    <li>񽺸   ִٸ RequestProcessor ؼ û óѴ.</li>
	 *    <li>û ó (Result) UICreator ؼ 並 Ѵ.</li>
	 *    <li>   ߻ߴٰ ǥõǾ ִٸ  並 Ѵ.</li>
	 * </ol>
	 * 
	 * @param request
	 * @param response
	 * @throws RequestAnalyzerException
	 * @throws ComponentException
	 */
	void processingRequest(HttpServletRequest request, HttpServletResponse response) throws ComponentException, RequestAnalyzerException {
		RequestInfo requestInfo = ra.analyzeRequest(request, response);
		
		HttpServletRequest realRequest = null;
		RequestInfo realRequestInfo = null;
		if (useWrapper) {
			realRequest = new RIRequestWrapper(request, requestInfo);
			realRequestInfo = new RequestInfoWrapper(requestInfo);
		} else {
			realRequest = request;
			realRequestInfo = requestInfo;
		}
		
		User user = aaManager.getSessionUser(realRequest);
		Service service = aaManager.getService(realRequestInfo);
		
		boolean enable = false;
		
		try {
			if (service.isNeedAuthentication()) {
				//  ʿ  
				if (user instanceof NullUser) {
					//  ڰ ƴ     ̵Ѵ.
					uiCreator.createAuthenticationForm(realRequest, response);
					return;
				} else {
					//   
					if (service.isAllRolesUsable()) {
						//   밡 
						enable = true;
					} else {
						// Ư Ҹ 밡 
						enable = aaManager.checkAuthorization(user, service);
					}
				}
			} else {
				//  ʿ   
				enable = true;
			}
			if (enable) {
				Result result = rp.process(realRequestInfo);
				if (result.isErrorOccured()) {
					uiCreator.createErrorView(result, realRequest, response);
				} else {
					uiCreator.createView(result, realRequest, response);
				}
			} else {
				uiCreator.createNoAuthorizationView(realRequestInfo, realRequest, response);
			}
		} catch (Throwable e) {
			Logger.fatal(e.getMessage(), e);
			uiCreator.createErrorView(e, request, response);
		}
	}
}
