/*
 * Ʈ: TLE2Framework
 * ϸ: ServiceManagerConfigurationDigesterTest.java
 * ۼ: 2004. 11. 10
 */
package test.tle.framework.component.impl.aamanager.service;

import java.io.IOException;
import java.util.List;
import java.util.Map;

import org.xml.sax.SAXException;

import tle.framework.component.impl.aamanager.service.ServiceGroup;
import tle.framework.component.impl.aamanager.service.ServiceManagerConfiguration;
import tle.framework.component.impl.aamanager.service.ServiceManagerConfigurationDigester;
import tle.framework.component.spi.aamanager.Service;
import junit.framework.TestCase;

/**
 * ServiceManagerConfigurationDigester ׽Ʈ Ŭ
 * 
 * @author ֹ
 * @since 2.0
 */
public class ServiceManagerConfigurationDigesterTest extends TestCase {

	public void testCreate() throws IOException, SAXException {
		ServiceManagerConfiguration configuration = ServiceManagerConfigurationDigester.create("c:/eclipse/workspace/TLE2Framework/config/Service.xml");
		List groupList = configuration.getServiceGroupList();
		
		assertEquals(3, groupList.size());
		Map groupMap = new java.util.HashMap();
		for (int i = 0 ; i < groupList.size() ; i++) {
			ServiceGroup group = (ServiceGroup)groupList.get(i);
			groupMap.put(group.getCommandPrefix(), group);
		}
		ServiceGroup group = null;
		
		group = (ServiceGroup)groupMap.get("/board/write");
		assertEquals("/board/write", group.getCommandPrefix());
		assertEquals(true, group.isNeedAuthentication());
		assertEquals(true, group.isAllRolesUsable());

		group = (ServiceGroup)groupMap.get("/board/");
		assertEquals("/board/", group.getCommandPrefix());
		assertEquals(false, group.isNeedAuthentication());
		assertEquals(true, group.isAllRolesUsable());

		group = (ServiceGroup)groupMap.get("/board/admin/");
		assertEquals("/board/admin/", group.getCommandPrefix());
		assertEquals(true, group.isNeedAuthentication());
		assertEquals(false, group.isAllRolesUsable());
		assertTrue(group.hasGrant("admin"));
		assertFalse(group.hasGrant("regular"));
		
		List serviceList = configuration.getServiceList();
		
		assertEquals(3, serviceList.size());

		Map serviceMap = new java.util.HashMap();
		for (int i = 0 ; i < serviceList.size() ; i++) {
			Service service = (Service)serviceList.get(i);
			serviceMap.put(service.getCommandID(), service);
		}
		Service service = null;
		
		service = (Service)serviceMap.get("/board/write.do");
		assertEquals("/board/write.do", service.getCommandID());
		assertEquals("۾", service.getName());
		assertEquals(true, service.isNeedAuthentication());
		assertEquals(true, service.isAllRolesUsable());

		service = (Service)serviceMap.get("/member/auth/login.do");
		assertEquals("/member/auth/login.do", service.getCommandID());
		assertEquals(false, service.isNeedAuthentication());
		assertEquals(true, service.isAllRolesUsable());

	}
}
