/*
 * Ʈ: TLE2Framework
 * ϸ: SessionManager.java
 * ۼ: 2004. 10. 26
 */
package tle.framework.component.impl.aamanager;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import tle.framework.component.ComponentConfig;
import tle.framework.component.spi.aamanager.AAManagerException;
import tle.framework.component.spi.aamanager.User;

/**
 * DefaultAAManager   ϴ SessionManager ̽.
 * <p>
 * DefaultAAManager ϴ ø̼   óִ SessionManager ü ؾ Ѵ.
 * 
 * @author ֹ
 * @since 2.0 
 */
public interface SessionManager {
	/**
	 * Ʈ ʱȭ  ؼ SessionManager ʱȭѴ.
	 * 
	 * @param configuration
	 * @throws AAManagerException
	 */
	public void init(ComponentConfig configuration) throws AAManagerException;

	/**
	 *   Ѵ.
	 * 
	 * @param user 
	 * @param request HTTP û
	 * @param response HTTP 
	 */
	public void openSession(User user, HttpServletRequest request, HttpServletResponse response)
	throws AAManagerException;

	/**
	 *   Ѵ.
	 * 
	 * @param request HTTP û
	 * @param response HTTP 
	 */
	public void closeSession(HttpServletRequest request, HttpServletResponse response)
	throws AAManagerException;

	/**
	 *     Ѵ.
	 * 
	 * @param request HTTP û
	 * @return ǿ  User.    null 
	 */
	public User getSessionUser(HttpServletRequest request)
	throws AAManagerException;
	
}
