/*
 * Ʈ: TLE2Framework
 * ϸ: DefaultFileItem.java
 * ۼ: 2004. 10. 21
 */
package tle.framework.component.impl.ra;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

import tle.framework.component.spi.ra.FileItem;

/**
 * FileItem ⺻ ü
 * 
 * @author ֹ
 * @since 2.0 
 */
public class DefaultFileItem implements FileItem {
	/**
	 *  ̸ Ѵ.
	 */
	private String fileName;
	
	/**
	 * org.apache.commons.fileupload.FileItem  ۷
	 */
	private org.apache.commons.fileupload.FileItem apacheFileItem = null;
	
	/**
	 * ġ FileUpload API FileItem ޹ް ε  ̸ Ѵ. 
	 * @param apacheFileItem
	 */
	void init(org.apache.commons.fileupload.FileItem apacheFileItem) {
		this.apacheFileItem = apacheFileItem;
		int idx = apacheFileItem.getName().lastIndexOf("\\");
		if (idx == -1) {
			idx = apacheFileItem.getName().lastIndexOf("/");
		}
		this.fileName = apacheFileItem.getName().substring(idx + 1);
	}

	/* (non-Javadoc)
	 * @see tle.framework.component.spi.ra.FileItem#getParameterName()
	 */
	public String getParameterName() {
		return apacheFileItem.getFieldName();
	}

	/* (non-Javadoc)
	 * @see tle.framework.component.spi.ra.FileItem#getFilePath()
	 */
	public String getFilePath() {
		return apacheFileItem.getName();
	}

	/* (non-Javadoc)
	 * @see tle.framework.component.spi.ra.FileItem#getFileName()
	 */
	public String getFileName() {
		return fileName;
	}

	/* (non-Javadoc)
	 * @see tle.framework.component.spi.ra.FileItem#getSize()
	 */
	public long getSize() {
		return apacheFileItem.getSize();
	}

	/* (non-Javadoc)
	 * @see tle.framework.component.spi.ra.FileItem#getBytes()
	 */
	public byte[] getBytes() {
		return apacheFileItem.get();
	}

	/* (non-Javadoc)
	 * @see tle.framework.component.spi.ra.FileItem#getInputStream()
	 */
	public InputStream getInputStream() throws IOException {
		return apacheFileItem.getInputStream();
	}

	/* (non-Javadoc)
	 * @see tle.framework.component.spi.ra.FileItem#write(java.io.File)
	 */
	public void write(File file) throws Exception {
		apacheFileItem.write(file);
	}
	

	/* (non-Javadoc)
	 * @see tle.framework.component.spi.ra.FileItem#write(java.io.OutputStream)
	 */
	public void write(OutputStream out) throws Exception {
		out.write(apacheFileItem.get());
	}
}
