/*
 * Ʈ: TLE2Framework
 * ϸ: ComponentBase.java
 * ۼ: 2004. 10. 13.
 */
package tle.framework.component.impl;

import tle.framework.component.Component;
import tle.framework.component.ComponentConfig;
import tle.framework.component.ComponentException;
import tle.framework.component.ComponentState;

/**
 * Component ̽  Ŭ ̽ Ŭ   ִ ߻ Ŭ.
 *  Ŭ õ ޼ҵ ȣ Ʈ  ̸ óش.
 * 
 * @author ֹ
 * @since 2.0 
 */
public abstract class ComponentBase implements Component {
	
	protected ComponentState componentState = new ComponentState();
	
	protected ComponentConfig config = null;
	
	/**
	 * Ʈ ¸ "NOT_CREATED" ¿ "CREATED" Ѵ.
	 */
	public ComponentBase() {
		componentState.event(ComponentState.CREATE_EVENT);
	}
	
	
	/**
	 * initing() ޼ҵ ޹ ComponentConfig.getID() ޼ҵ  Ѵ.
	 * 
	 * @see tle.framework.component.Component#getID()
	 */
	public String getID() {
		return config.getComponentID();
	}
	
	/**
	 * Ʈ ʱȭѴ.
	 * <p>
	 *  Ŭ  ޼ҵ带 ̵Ͽ Ʈ ʱȭ Ѵ.
	 * 
	 * @param config Ʈ ʱȭ    ִ ü
	 * @throws ComponentException
	 */
	protected void initing(ComponentConfig config) throws ComponentException {
	}
	
	/**
	 * initing() ޼ҵ带 ȣϿ Ʈ ʱȭѴ.
	 * <p>
	 * ó  ["INITING"   -> initing() ȣ -> "INITED"  ] ̴.
	 * protected ʵ config ڷ ޹ config ҴѴ.
	 *  
	 * @see tle.framework.component.Component#init()
	 */
	public final void init(ComponentConfig config) throws ComponentException {
		componentState.event(ComponentState.INIT_EVENT);
		this.config = config;
		
		initing(config);
		componentState.event(ComponentState.COMPLETE_EVENT);
	}
	
	/**
	 * Ʈ Ѵ.
	 * <p>
	 *  Ŭ  ޼ҵ带 ̵Ͽ Ʈ  ۾ Ѵ.
	 *  ޼ҵ带     starting() ޼ҵ尡  ðȿ ؾ Ѵٴ ̴.
	 *  Ʈ  ʿ   ʿ   
	 * starting() ޼ҵ尡 ƴ  忡 ۾ ؾ Ѵ.
	 *  
	 * @throws ComponentException
	 */
	protected void starting() throws ComponentException {
	}
	
	/**
	 * starting() ޼ҵ带 ȣϿ Ʈ Ѵ.
	 * <p>
	 * ó  ["STARTING"   -> initing() ȣ -> "RUNNING"  ] ̴. 
	 * @see tle.framework.component.Component#start()
	 */
	public final void start() throws ComponentException {
		componentState.event(ComponentState.START_EVENT);
		starting();
		componentState.event(ComponentState.COMPLETE_EVENT);
	}
	
	/**
	 * Ʈ Ͻ Ѵ.
	 * <p>
	 *  Ŭ  ޼ҵ带 ̵Ͽ Ʈ Ͻ ۾ óѴ.
	 * 
	 * @throws ComponentException
	 */
	protected void suspending() throws ComponentException {
	}
	
	/**
	 * suspending() ޼ҵ带 ȣϿ Ʈ Ͻ Ѵ.
	 * <p>
	 * ó  ["SUSPENDING"   -> suspending() ȣ -> "SUSPENDED"  ] ̴. 
	 * 
	 * @see tle.framework.component.Component#suspend()
	 */
	public final void suspend() throws ComponentException {
		componentState.event(ComponentState.SUSPEND_EVENT);
		suspending();
		componentState.event(ComponentState.COMPLETE_EVENT);
	}
	
	/**
	 * Ͻ  Ʈ ٽ Ѵ.
	 * <p>
	 *  Ŭ  ޼ҵ带 ̵Ͽ Ʈ 籸 ۾ Ѵ.
	 * 
	 * @throws ComponentException
	 */
	protected void resuming() throws ComponentException {
	}
	
	/**
	 * resuming() ޼ҵ带 ȣϿ Ͻ Ʈ 籸Ѵ.
	 * <p>
	 * ó  ["SUSPENDING"   -> suspending() ȣ -> "SUSPENDED"  ] ̴.
	 *  
	 * @see tle.framework.component.Component#resume()
	 */
	public final void resume() throws ComponentException {
		componentState.event(ComponentState.RESUME_EVENT);
		suspending();
		componentState.event(ComponentState.COMPLETE_EVENT);
	}
	
	/**
	 *  Ʈ Ѵ.
	 * <p>
	 *  Ŭ  ޼ҵ带 ̵Ͽ Ʈ  ۾ Ѵ.
	 * 
	 * @throws ComponentException
	 */
	protected void stopping() throws ComponentException {
	}
	
	/**
	 * resuming() ޼ҵ带 ȣϿ Ͻ Ʈ 籸Ѵ.
	 * <p>
	 * ó  ["STOPPING"   -> stop() ȣ -> "STOPPED"  ] ̴.
	 * 
	 * @see tle.framework.component.Component#stop()
	 */
	public final void stop() throws ComponentException {
		componentState.event(ComponentState.STOP_EVENT);
		suspending();
		componentState.event(ComponentState.COMPLETE_EVENT);
	}
	
	/**
	 *  Ʈ Ѵ.
	 * <p>
	 *  Ŭ  ޼ҵ带 ̵Ͽ Ʈ  ۾ Ѵ.
	 * 
	 * @throws ComponentException
	 */
	protected void closing() throws ComponentException {
	}
	
	/**
	 * resuming() ޼ҵ带 ȣϿ Ͻ Ʈ 籸Ѵ.
	 * <p>
	 * ó  ["CLOSING"   -> stop() ȣ -> "CLOSED"  ] ̴.
	 * 
	 * @see tle.framework.component.Component#close()
	 */
	public final void close() throws ComponentException {
		componentState.event(ComponentState.CLOSE_EVENT);
		closing();
		componentState.event(ComponentState.COMPLETE_EVENT);
	}

	/**
	 * init() ޹ ComponentConfig getDescription() ޼ҵ   Ѵ.
	 * @see tle.framework.component.ComponentMBean#getDescription()
	 */
	public String getDescription() {
		return config.getDescription();
	}

	public final String getState() {
		return componentState.getCurrentState().getStateName();
	}

	public boolean isCreated() {
		return componentState.isCreated();
	}
	public boolean isClosed() {
		return componentState.isClosed();
	}
	public boolean isClosing() {
		return componentState.isClosing();
	}
	public boolean isErrorOccured() {
		return componentState.isErrorOccured();
	}
	public boolean isInited() {
		return componentState.isInited();
	}
	public boolean isIniting() {
		return componentState.isIniting();
	}
	public boolean isResuming() {
		return componentState.isResuming();
	}
	public boolean isRunning() {
		return componentState.isRunning();
	}
	public boolean isStarting() {
		return componentState.isStarting();
	}
	public boolean isStopped() {
		return componentState.isStopped();
	}
	public boolean isStopping() {
		return componentState.isStopping();
	}
	public boolean isSuspended() {
		return componentState.isSuspended();
	}
	public boolean isSuspending() {
		return componentState.isSuspending();
	}
}
