/*
 * Ʈ: TLE2Framework
 * ϸ: TLEConfigDigester.java
 * ۼ: 2004. 10. 18
 */
package tle.framework.configuration;

import java.io.File;
import java.io.IOException;
import java.net.URL;

import org.apache.commons.digester.Digester;
import org.apache.commons.digester.xmlrules.DigesterLoader;
import org.xml.sax.SAXException;

/**
 * Ʋ ӿũ     TLEConfig ü Ѵ.
 * <p>
 * Jakarta Common Digester API Ͽ о´. 
 * 
 * @author ֹ
 * @since 2.0 
 */
public class TLEConfigDigester {
	private static Digester digester = null;
	
	public static TLEConfig create(String filePath) throws IOException, SAXException {
		if (digester == null) {
			TLEConfigDigester.initDigester();
		}
		File configFile = new File(filePath);
		TLEConfig configuration = (TLEConfig)digester.parse(configFile);
		return configuration;
	}
	
	private static void initDigester() {
		synchronized(TLEConfigDigester.class) {
			if (digester == null) {
				URL ruleXml = TLEConfigDigester.class.getClassLoader().getResource("tle/framework/configuration/TLEConfig.rule.xml");
				digester = DigesterLoader.createDigester(ruleXml);
			}
		}
	}
}