/*
 * Decompiled with CFR 0.152.
 */
package tle.framework.jmx;

import javax.management.MBeanServer;
import javax.management.ObjectName;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import mx4j.tools.adaptor.http.HttpAdaptor;
import mx4j.tools.adaptor.http.ProcessorMBean;
import mx4j.tools.adaptor.http.XSLTProcessor;
import tle.framework.jmx.MBeanServerWrapper;
import tle.framework.log.Logger;
import tle.framework.util.TLEConfigPathUtil;

public class RegistHttpAdaptorMBeanServlet
extends HttpServlet {
    private ObjectName serverName = null;
    private ObjectName processorName = null;

    public void init(ServletConfig config) throws ServletException {
        super.init(config);
        String host = config.getInitParameter("host");
        String port = config.getInitParameter("port");
        String user = config.getInitParameter("user");
        String password = config.getInitParameter("password");
        String xslJarFile = config.getInitParameter("xslJar");
        MBeanServer server = MBeanServerWrapper.getInstance().getMBeanServer();
        try {
            HttpAdaptor httpAdaptor = new HttpAdaptor();
            if (host != null) {
                httpAdaptor.setHost(host);
            }
            if (port != null) {
                int portNo = Integer.parseInt(port);
                httpAdaptor.setPort(portNo);
            }
            httpAdaptor.setAuthenticationMethod("basic");
            httpAdaptor.addAuthorization(user, password);
            this.serverName = new ObjectName("Http:name=HttpAdaptor");
            this.processorName = new ObjectName("Http:name=XSLTProcessor");
            XSLTProcessor processor = new XSLTProcessor();
            processor.setUseCache(false);
            processor.setFile(TLEConfigPathUtil.replace(xslJarFile));
            processor.setPathInJar("mx4j/tools/adaptor/http/xsl");
            httpAdaptor.setProcessor((ProcessorMBean)processor);
            server.registerMBean(processor, this.processorName);
            server.registerMBean(httpAdaptor, this.serverName);
            server.invoke(this.serverName, "start", null, null);
        }
        catch (Throwable e) {
            Logger.warn(e.getMessage(), e);
        }
    }

    public void destroy() {
        super.destroy();
        MBeanServer server = MBeanServerWrapper.getInstance().getMBeanServer();
        try {
            server.invoke(this.serverName, "stop", null, null);
            server.unregisterMBean(this.serverName);
            server.unregisterMBean(this.processorName);
        }
        catch (Throwable e) {
            Logger.warn(e.getMessage(), e);
        }
    }
}

