/*
 * Decompiled with CFR 0.152.
 */
package javax.management;

import java.io.Serializable;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.management.RuntimeOperationsException;

public class ObjectInstance
implements Serializable {
    private static final long serialVersionUID = -4099952623687795850L;
    private String className;
    private ObjectName name;

    public ObjectInstance(String objectName, String className) throws MalformedObjectNameException {
        this(new ObjectName(objectName), className);
    }

    public ObjectInstance(ObjectName objectName, String className) {
        if (objectName == null || objectName.isPattern()) {
            throw new RuntimeOperationsException(new IllegalArgumentException("Invalid object name"));
        }
        if (className == null || className.trim().length() == 0) {
            throw new RuntimeOperationsException(new IllegalArgumentException("Class name cannot be null or empty"));
        }
        this.name = objectName;
        this.className = className;
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (object == this) {
            return true;
        }
        try {
            ObjectInstance other = (ObjectInstance)object;
            return this.name.equals(other.name) && this.className.equals(other.className);
        }
        catch (ClassCastException classCastException) {
            return false;
        }
    }

    public int hashCode() {
        return this.name.hashCode() ^ this.className.hashCode();
    }

    public ObjectName getObjectName() {
        return this.name;
    }

    public String getClassName() {
        return this.className;
    }

    public String toString() {
        return this.getClassName() + "@" + this.getObjectName();
    }
}

