/*
 * Ʈ: TLE2Framework
 * ϸ: DefaultRPConfigurationDigester.java
 * ۼ: 2004. 10. 25
 */
package tle.framework.component.impl.rp.config;

import java.io.File;
import java.io.IOException;
import java.net.URL;

import org.apache.commons.digester.Digester;
import org.apache.commons.digester.xmlrules.DigesterLoader;
import org.xml.sax.SAXException;

/**
 * DefaultRPConfiguration.rule.xml Ģ  ؼ
 *   Ϸκ ͸ о DefaultRPConfiguration ü Ѵ.
 * 
 * @author ֹ
 * @since 2.0
 */
public class DefaultRPConfigurationDigester {
	private static Digester digester = null;
	
	public static DefaultRPConfiguration create(String filePath) throws IOException, SAXException {
		if (digester == null) {
			DefaultRPConfigurationDigester.initDigester();
		}
		File configFile = new File(filePath);
		DefaultRPConfiguration configuration = (DefaultRPConfiguration)digester.parse(configFile);
		return configuration;
	}
	
	private static void initDigester() {
		synchronized(DefaultRPConfigurationDigester.class) {
			if (digester == null) {
				URL ruleXml = DefaultRPConfigurationDigester.class.getClassLoader().getResource("tle/framework/component/impl/rp/config/DefaultRPConfiguration.rule.xml");
				digester = DigesterLoader.createDigester(ruleXml);
			}
		}
	}
}
