/*
 * Ʈ: TLE2Framework
 * ϸ: JSPCommandHandler.java
 * ۼ: 2004. 11. 2
 */
package tle.framework.component.impl.rp.handler;

import java.io.IOException;

import javax.servlet.RequestDispatcher;
import javax.servlet.ServletException;

import tle.framework.component.impl.rp.DefaultResult;
import tle.framework.component.spi.ra.RequestInfo;

/**
 * JSP CommandHandler  Ŭ. 
 * 
 * @author ֹ
 * @since 2.0 
 */
public class JSPCommandHandler implements CommandHandler {
	
	private String handlerJSPPage;
	
	public JSPCommandHandler(String handlerJSPPage) {
		this.handlerJSPPage = handlerJSPPage;
	}
	
	/**
	 * ڿ ޹ JSP  include Ѵ. 
	 * <p>
	 * ̶, ڷ ޹ ri result  
	 * request ü requestInfo Ӽ result Ӽ Ǿ 
	 * JSP  ޵ȴ.
	 * 
	 * @see tle.framework.component.impl.rp.handler.CommandHandler#process(tle.framework.component.spi.ra.RequestInfo, tle.framework.component.impl.rp.DefaultResult)
	 */
	public DefaultResult process(RequestInfo ri, DefaultResult result) {
		RequestDispatcher rd = ri.getRequest().getRequestDispatcher(handlerJSPPage);
		
		try {
			ri.getRequest().setAttribute("requestInfo", ri);
			ri.getRequest().setAttribute("result", result);
			
			rd.include(ri.getRequest(), ri.getResponse());
		} catch (ServletException e) {
			result.setErrorOccured(true);
			result.setException(e);
			result.addErrorMessage(e.getMessage());
		} catch (IOException e) {
			result.setErrorOccured(true);
			result.setException(e);
			result.addErrorMessage(e.getMessage());
		}
		return result;
	}

}
