/*
 * Decompiled with CFR 0.152.
 */
package tle.framework.component.impl.rp.handler;

import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import tle.framework.component.impl.rp.config.DefaultRPConfiguration;
import tle.framework.component.impl.rp.handler.CommandHandler;
import tle.framework.component.impl.rp.handler.CommandHandlerClassLoader;
import tle.framework.component.impl.rp.handler.GoViewCommandHandler;
import tle.framework.component.impl.rp.handler.JSPCommandHandler;
import tle.framework.component.impl.rp.handler.NoHandlerCommandHandler;
import tle.framework.component.spi.ra.RequestInfo;
import tle.framework.log.Logger;

public class CommandHandlerFactory {
    private CommandHandlerClassLoader commandHandlerClassLoader;
    private Map handlerMap;
    private Map commandHandlerMap;
    private CommandHandler defaultHandler = null;

    public CommandHandlerFactory(DefaultRPConfiguration configuration) {
        if (configuration.isUsingIndependentClassPath()) {
            this.commandHandlerClassLoader = new CommandHandlerClassLoader(configuration.getClassPathArray());
        }
        this.init(configuration);
    }

    public void init(DefaultRPConfiguration configuration) {
        this.initHandler(configuration);
        this.initCommandHandlerMapping(configuration);
    }

    private void initHandler(DefaultRPConfiguration configuration) {
        this.initHandlerInstance(configuration);
        this.initDefaultHandler(configuration);
    }

    private void initHandlerInstance(DefaultRPConfiguration configuration) {
        HashMap<String, CommandHandler> handlerMap = new HashMap<String, CommandHandler>();
        Map handlerClassMap = configuration.getHandlerClassMap();
        Iterator iter = handlerClassMap.keySet().iterator();
        while (iter.hasNext()) {
            String handlerID = (String)iter.next();
            String className = (String)handlerClassMap.get(handlerID);
            try {
                Class handlerClass = null;
                handlerClass = this.commandHandlerClassLoader != null ? this.commandHandlerClassLoader.loadHandlerClass(className) : Class.forName(className);
                CommandHandler handler = (CommandHandler)handlerClass.newInstance();
                handlerMap.put(handlerID, handler);
            }
            catch (ClassNotFoundException e) {
                Logger.warn("", e);
            }
            catch (InstantiationException e) {
                Logger.warn("", e);
            }
            catch (IllegalAccessException e) {
                Logger.warn("", e);
            }
            catch (ClassCastException e) {
                Logger.warn("", e);
            }
        }
        Map handlerJspMap = configuration.getHandlerJspMap();
        Iterator iterJsp = handlerJspMap.keySet().iterator();
        while (iterJsp.hasNext()) {
            String handlerID = (String)iterJsp.next();
            String jspPage = (String)handlerJspMap.get(handlerID);
            JSPCommandHandler handler = new JSPCommandHandler(jspPage);
            handlerMap.put(handlerID, handler);
        }
        this.handlerMap = handlerMap;
    }

    private void initDefaultHandler(DefaultRPConfiguration configuration) {
        GoViewCommandHandler goViewHandler = new GoViewCommandHandler();
        NoHandlerCommandHandler noHandler = new NoHandlerCommandHandler();
        switch (configuration.getDefaultHandlerType()) {
            case 1: {
                this.defaultHandler = goViewHandler;
                break;
            }
            case 2: {
                this.defaultHandler = noHandler;
            }
        }
        this.handlerMap.put("default.GOVIEW", goViewHandler);
        this.handlerMap.put("default.NOHANDLER", noHandler);
    }

    private void initCommandHandlerMapping(DefaultRPConfiguration configuration) {
        this.commandHandlerMap = Collections.unmodifiableMap(configuration.getCommandHandlerMap());
    }

    public CommandHandler createCommandHandler(RequestInfo requestInfo) {
        String handlerID = (String)this.commandHandlerMap.get(requestInfo.getCommandID());
        CommandHandler handler = (CommandHandler)this.handlerMap.get(handlerID);
        if (handler == null) {
            return this.defaultHandler;
        }
        return handler;
    }

    public void reloadHandlerClasses(DefaultRPConfiguration configuration) {
        if (this.commandHandlerClassLoader == null) {
            throw new UnsupportedOperationException("ClassLoader != CommandHandlerClassLoader");
        }
        this.commandHandlerClassLoader.remakeClassLoader();
        this.initHandler(configuration);
    }
}

