/*
 * Ʈ: TLE2Framework
 * ϸ: RegistHttpAdaptorMBeanServlet.java
 * ۼ: 2004. 11. 9
 */
package tle.framework.jmx;

import javax.management.MBeanServer;
import javax.management.ObjectName;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;

import mx4j.tools.adaptor.http.HttpAdaptor;
import mx4j.tools.adaptor.http.XSLTProcessor;

import tle.framework.log.Logger;
import tle.framework.util.TLEConfigPathUtil;

/**
 * MX4J 2.0.1  , MX4J ϴ Http Adaptor 
 * MBean Ʈ ִ . Http Adaptor ؼ
 * Ʋ ӿũ ϵ Ʈ    ְ ȴ.
 * <p>
 *  ø̼  ڵ ǵ web.xml Ͽ 
 * ߰ش.
 * <p>
 * <pre>
 * 
 * &lt;servlet>
 *     &lt;servlet-name>RegistHttpAdaptor&lt;/servlet-name>
 *     &lt;servlet-class>tle.framework.jmx.RegistHttpAdaptorMBeanServlet&lt;/servlet-class>
 *     &lt;init-param>
 *         &lt;param-name>port&lt;/param-name>
 *         &lt;param-value>8088&lt;/param-value>
 *     &lt;/init-param>
 *     &lt;init-param>
 *         &lt;param-name>xslJar&lt;/param-name>
 *         &lt;param-value>mx4j-tools.jar&lt;/param-value>
 *     &lt;/init-param>
 *     &lt;init-param>
 *         &lt;param-name>user&lt;/param-name>
 *         &lt;param-value>admin&lt;/param-value>
 *     &lt;/init-param>
 *     &lt;init-param>
 *         &lt;param-name>password&lt;/param-name>
 *         &lt;param-value>cvnet&lt;/param-value>
 *     &lt;/init-param>
 *     &lt;load-on-startup>1&lt;/load-on-startup>
 * &lt;/servlet>
 * 
 * </pre>
 * 
 * <p> ʱȭ Ķʹ  .
 * <ul>
 *   <li>port - HttpAdaptor  Ʈ ȣ.
 *   <li>xslJar - MX4J ϴ mx4j-tools.jar  
 *   <li>user - HttpAdaptor ϴ       ̵
 *   <li>password - HttpAdaptor ϴ       ȣ
 * </ul>
 * 
 * xslJar ʱȭ Ķ  TLEConfigPathUtil.replace() ޼ҵ带 Ͽ
 * ȯ  ȴ.
 *  
 * @author ֹ
 * @since 2.0
 */
public class RegistHttpAdaptorMBeanServlet extends HttpServlet {

	private ObjectName serverName = null;
	private ObjectName processorName = null;

	/**
	 * HttpAdpator MBean Ѵ.
	 * @see javax.servlet.Servlet#init(javax.servlet.ServletConfig)
	 */
	public void init(ServletConfig config) throws ServletException {
		super.init(config);
		
		String host = config.getInitParameter("host");
		String port = config.getInitParameter("port");
		String user = config.getInitParameter("user");
		String password = config.getInitParameter("password");
		String xslJarFile = config.getInitParameter("xslJar");
		
		MBeanServer server = MBeanServerWrapper.getInstance().getMBeanServer();
		try {
			HttpAdaptor httpAdaptor = new HttpAdaptor();
			if (host != null) {
				httpAdaptor.setHost(host);
			}
			if (port != null) {
				int portNo = Integer.parseInt(port);
				httpAdaptor.setPort(portNo);
			}
			httpAdaptor.setAuthenticationMethod("basic");
			httpAdaptor.addAuthorization(user, password);
			
			serverName = new ObjectName("Http:name=HttpAdaptor");
			processorName = new ObjectName("Http:name=XSLTProcessor");
			
			XSLTProcessor processor = new XSLTProcessor();
			processor.setUseCache(false);
			processor.setFile(TLEConfigPathUtil.replace(xslJarFile));
			processor.setPathInJar("mx4j/tools/adaptor/http/xsl");
			httpAdaptor.setProcessor(processor);
			
			server.registerMBean(processor, processorName);
			server.registerMBean(httpAdaptor, serverName);
			server.invoke(serverName, "start", null, null);
		} catch (Throwable e) {
			Logger.warn(e.getMessage(), e);
		}
	}
	
	
	/**
	 *  HttpAdaptor MBean Ѵ.
	 * @see javax.servlet.Servlet#destroy()
	 */
	public void destroy() {
		super.destroy();
		MBeanServer server = MBeanServerWrapper.getInstance().getMBeanServer();
		
		try {
			server.invoke(serverName, "stop", null, null);
			server.unregisterMBean(serverName);
			server.unregisterMBean(processorName);
		} catch (Throwable e) {
			Logger.warn(e.getMessage(), e);
		}
		
	}
}
