/*
 * Ʈ: TLE2Framework
 * ϸ: UIConfiguration.java
 * ۼ: 2004. 10. 29
 */
package tle.framework.component.impl.uicreator.config;

import java.util.Map;

/**
 *  Ͽ   Ѵ.
 * 
 * @author ֹ
 * @since 2.0
 */
public class UIConfiguration {
	private Map viewSetConfigMap = new java.util.HashMap();
	private Map commandConfigMap = new java.util.HashMap();
	private String defaultViewSetID;
	private Map clientMap = new java.util.HashMap();
	
	public void addViewSetConfig(ViewSetConfig viewSetConfig) {
		viewSetConfigMap.put(viewSetConfig.getViewSetID(), viewSetConfig);
	}
	public ViewSetConfig getViewSetConfig(String viewSetID) {
		return (ViewSetConfig)viewSetConfigMap.get(viewSetID);
	}
	public void addCommandConfig(CommandConfig commandConfig) {
		commandConfigMap.put(commandConfig.getCommandID(), commandConfig);
	}
	public CommandConfig getCommandConfig(String commandID) {
		return (CommandConfig)commandConfigMap.get(commandID);
	}
	public void setDefaultViewSet(String viewSetID) {
		this.defaultViewSetID = viewSetID;
	}
	public ViewSetConfig getDefaultViewSetConfig() {
		return (ViewSetConfig)viewSetConfigMap.get(defaultViewSetID);
	}
	public void addClient(String clientType, String viewSetID) {
		clientMap.put(clientType, viewSetID);
	}
	public ViewSetConfig getClientViewSetConfig(String clientType) {
		String viewSetID = (String)clientMap.get(clientType);
		ViewSetConfig viewSet = (ViewSetConfig)viewSetConfigMap.get(viewSetID);
		if (viewSet == null) {
			viewSet = getDefaultViewSetConfig();
		}
		return viewSet;
	}
}
