/*
 * Decompiled with CFR 0.152.
 */
package mx4j.tools.adaptor.http;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.StringTokenizer;
import javax.management.MBeanException;
import javax.management.ReflectionException;
import javax.management.RuntimeMBeanException;
import javax.xml.transform.Source;
import javax.xml.transform.Templates;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.URIResolver;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import mx4j.log.Log;
import mx4j.log.Logger;
import mx4j.tools.adaptor.http.HttpException;
import mx4j.tools.adaptor.http.HttpInputStream;
import mx4j.tools.adaptor.http.HttpOutputStream;
import mx4j.tools.adaptor.http.ProcessorMBean;
import mx4j.tools.adaptor.http.XSLTProcessorMBean;
import org.w3c.dom.Document;

public class XSLTProcessor
implements ProcessorMBean,
XSLTProcessorMBean,
URIResolver {
    private String path = "mx4j/tools/adaptor/http/xsl";
    private String defaultPage = "serverbydomain";
    private TransformerFactory factory;
    private Map templatesCache = new HashMap();
    private File root;
    private Map mimeTypes = new HashMap();
    private boolean useJar = true;
    private volatile boolean useCache = true;
    private ClassLoader targetClassLoader = ClassLoader.getSystemClassLoader();
    private Locale locale = new Locale("en", "");

    public XSLTProcessor() {
        this.factory = TransformerFactory.newInstance();
        this.factory.setURIResolver(this);
        this.mimeTypes.put(".gif", "image/gif");
        this.mimeTypes.put(".jpg", "image/jpg");
        this.mimeTypes.put(".png", "image/png");
        this.mimeTypes.put(".tif", "image/tiff");
        this.mimeTypes.put(".tiff", "image/tiff");
        this.mimeTypes.put(".ico", "image/ico");
        this.mimeTypes.put(".html", "text/html");
        this.mimeTypes.put(".htm", "text/html");
        this.mimeTypes.put(".txt", "text/plain");
        this.mimeTypes.put(".xml", "text/xml");
        this.mimeTypes.put(".xsl", "text/xsl");
        this.mimeTypes.put(".css", "text/css");
        this.mimeTypes.put(".js", "text/x-javascript");
        this.mimeTypes.put(".jar", "application/java-archive");
    }

    private Logger getLogger() {
        return Log.getLogger(this.getClass().getName());
    }

    public void writeResponse(HttpOutputStream out, HttpInputStream in, Document document) throws IOException {
        Logger log = this.getLogger();
        out.setCode(200);
        out.setHeader("Content-Type", "text/html");
        out.setHeader("Cache-Control", "no-cache");
        out.setHeader("expires", "now");
        out.setHeader("pragma", "no-cache");
        out.sendHeaders();
        Transformer transformer = null;
        String path = this.preProcess(in.getPath());
        transformer = in.getVariable("template") != null ? this.createTransformer(in.getVariable("template") + ".xsl") : this.createTransformer(path + ".xsl");
        if (transformer != null) {
            transformer.setURIResolver(this);
            Map variables = in.getVariables();
            Iterator j = variables.keySet().iterator();
            while (j.hasNext()) {
                String key = (String)j.next();
                Object value = variables.get(key);
                if (value instanceof String) {
                    transformer.setParameter("request." + key, value);
                }
                if (!(value instanceof String[])) continue;
                String[] allvalues = (String[])value;
                transformer.setParameter("request." + key, allvalues[0]);
            }
            if (!variables.containsKey("locale")) {
                transformer.setParameter("request.locale", this.locale.toString());
            }
            try {
                ByteArrayOutputStream output = new ByteArrayOutputStream();
                if (log.isEnabledFor(0)) {
                    log.trace("transforming " + path);
                }
                transformer.transform(new DOMSource(document), new StreamResult(output));
                output.writeTo(out);
            }
            catch (TransformerException e) {
                log.error("Transformation exception ", e);
            }
        } else {
            log.warn("Transformer for path " + path + " not found");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Transformer createTransformer(String path) {
        Logger logger = this.getLogger();
        try {
            XSLTProcessor xSLTProcessor = this;
            synchronized (xSLTProcessor) {
                if (this.useCache && this.templatesCache.containsKey(path)) {
                    return ((Templates)this.templatesCache.get(path)).newTransformer();
                }
                InputStream stream = this.getInputStream(path);
                if (stream != null) {
                    if (logger.isEnabledFor(10)) {
                        logger.debug("Creating template for path " + path);
                    }
                    Templates template = this.factory.newTemplates(new StreamSource(stream));
                    if (this.useCache) {
                        this.templatesCache.put(path, template);
                    }
                    return template.newTransformer();
                }
                if (logger.isEnabledFor(20)) {
                    logger.info("XSL template for path '" + path + "' not found");
                }
            }
        }
        catch (TransformerConfigurationException e) {
            logger.error("Exception during XSL template construction", e);
        }
        return null;
    }

    protected void processHttpException(HttpInputStream in, HttpOutputStream out, HttpException e) throws IOException {
        out.setCode(e.getCode());
        out.setHeader("Content-Type", "text/html");
        out.sendHeaders();
        Transformer transformer = this.createTransformer("error.xsl");
        transformer.setURIResolver(this);
        Document doc = e.getResponseDoc();
        if (doc != null) {
            try {
                if (!in.getVariables().containsKey("locale")) {
                    transformer.setParameter("request.locale", this.locale.toString());
                }
                ByteArrayOutputStream output = new ByteArrayOutputStream();
                transformer.transform(new DOMSource(doc), new StreamResult(output));
                output.writeTo(out);
            }
            catch (TransformerException ex) {
                Logger log = this.getLogger();
                log.error("Exception during error output", ex);
            }
        }
    }

    public void writeError(HttpOutputStream out, HttpInputStream in, Exception e) throws IOException {
        Logger log = this.getLogger();
        Exception t = e;
        if (e instanceof RuntimeMBeanException) {
            t = ((RuntimeMBeanException)e).getTargetException();
        }
        if (log.isEnabledFor(10)) {
            log.debug("Processing error " + t.getMessage());
        }
        if (t instanceof HttpException) {
            this.processHttpException(in, out, (HttpException)t);
        } else if (t instanceof MBeanException && ((MBeanException)t).getTargetException() instanceof HttpException) {
            this.processHttpException(in, out, (HttpException)((MBeanException)t).getTargetException());
        } else if (t instanceof ReflectionException && ((ReflectionException)t).getTargetException() instanceof HttpException) {
            this.processHttpException(in, out, (HttpException)((ReflectionException)t).getTargetException());
        } else {
            out.setCode(500);
            out.setHeader("Content-Type", "text/html");
            out.sendHeaders();
        }
    }

    public String preProcess(String path) {
        if (path.equals("/")) {
            path = "/" + this.defaultPage;
        }
        return path;
    }

    public String notFoundElement(String path, HttpOutputStream out, HttpInputStream in) throws IOException, HttpException {
        Logger log = this.getLogger();
        File file = new File(this.path, path);
        if (log.isEnabledFor(10)) {
            log.debug("Processing file request " + file);
        }
        String name = file.getName();
        int extensionIndex = name.lastIndexOf(46);
        String mime = null;
        if (extensionIndex < 0) {
            log.warn("Filename has no extensions " + file.toString());
            mime = "text/plain";
        } else {
            String extension = name.substring(extensionIndex, name.length());
            if (this.mimeTypes.containsKey(extension)) {
                mime = (String)this.mimeTypes.get(extension);
            } else {
                log.warn("MIME type not found " + extension);
                mime = "text/plain";
            }
        }
        try {
            if (log.isEnabledFor(10)) {
                log.debug("Trying to read file " + file);
            }
            BufferedInputStream fileIn = new BufferedInputStream(this.getInputStream(path));
            ByteArrayOutputStream outArray = new ByteArrayOutputStream();
            BufferedOutputStream outBuffer = new BufferedOutputStream(outArray);
            int piece = 0;
            while ((piece = fileIn.read()) >= 0) {
                outBuffer.write(piece);
            }
            outBuffer.flush();
            out.setCode(200);
            out.setHeader("Content-type", mime);
            out.sendHeaders();
            if (log.isEnabledFor(10)) {
                log.debug("File output " + mime);
            }
            outArray.writeTo(out);
            fileIn.close();
        }
        catch (Exception e) {
            log.warn("Exception loading file " + file, e);
            throw new HttpException(404, "file " + file + " not found");
        }
        return null;
    }

    protected InputStream getInputStream(String path) {
        InputStream file = null;
        if (!this.useJar) {
            try {
                file = new FileInputStream(new File(this.root, path));
            }
            catch (FileNotFoundException e) {
                Logger log = this.getLogger();
                log.error("File not found", e);
            }
        } else {
            String targetFile = this.path;
            targetFile = path.startsWith("/") ? targetFile + path : targetFile + "/" + path;
            if (this.root != null) {
                file = this.targetClassLoader.getResourceAsStream(targetFile);
            }
            if (file == null) {
                ClassLoader cl = this.getClass().getClassLoader();
                file = cl == null ? ClassLoader.getSystemClassLoader().getResourceAsStream(targetFile) : this.getClass().getClassLoader().getResourceAsStream(targetFile);
                file = this.getClass().getClassLoader().getResourceAsStream(targetFile);
            }
        }
        return file;
    }

    public Source resolve(String href, String base) {
        StreamSource source = new StreamSource(this.getInputStream(href));
        source.setSystemId(href);
        return source;
    }

    public void setFile(String file) {
        if (file != null) {
            Logger log = this.getLogger();
            File target = new File(file);
            if (!target.exists()) {
                log.warn("Target file " + file + " does not exist, defaulting to previous");
                return;
            }
            if (target.isDirectory()) {
                this.useJar = false;
                if (log.isEnabledFor(10)) {
                    log.debug("Using " + file + " as the root dir");
                }
                this.root = target;
                return;
            }
            if (target.isFile() && (target.getName().endsWith(".jar") || target.getName().endsWith(".zip"))) {
                try {
                    URL url = target.toURL();
                    this.targetClassLoader = new URLClassLoader(new URL[]{url});
                    if (log.isEnabledFor(10)) {
                        log.debug("Using compressed file " + url + " as the root file");
                    }
                    this.root = target;
                    this.useJar = true;
                }
                catch (MalformedURLException e) {
                    log.warn("Unable to create class loader", e);
                }
            } else {
                log.warn("Target file " + file + " does not exist, defaulting to previous");
            }
        }
    }

    public String getFile() {
        return this.root != null ? this.root.getName() : null;
    }

    public String getPathInJar() {
        return this.path;
    }

    public void setPathInJar(String path) {
        this.path = path;
    }

    public String getDefaultPage() {
        return this.defaultPage;
    }

    public void setDefaultPage(String defaultPage) {
        this.defaultPage = defaultPage;
    }

    public boolean isUseJar() {
        return this.useJar;
    }

    public boolean isUsePath() {
        return !this.useJar;
    }

    public void addMimeType(String extension, String type) {
        if (extension != null && type != null) {
            Logger log = this.getLogger();
            if (log.isEnabledFor(10)) {
                log.debug("Added MIME type " + type + " for extension " + extension);
            }
            this.mimeTypes.put(extension, type);
        }
    }

    public void setUseCache(boolean useCache) {
        this.useCache = useCache;
    }

    public boolean isUseCache() {
        return this.useCache;
    }

    public String getName() {
        return "XSLT Processor";
    }

    public Locale getLocale() {
        return this.locale;
    }

    public void setLocale(Locale locale) {
        this.locale = locale;
    }

    public void setLocaleString(String locale) {
        if (locale == null || locale.length() == 0) {
            this.locale = new Locale("en", "");
        } else {
            StringTokenizer tknzr = new StringTokenizer(locale, "_");
            String language = tknzr.nextToken();
            String country = "";
            String variant = "";
            if (tknzr.hasMoreTokens()) {
                country = tknzr.nextToken();
            }
            if (tknzr.hasMoreTokens()) {
                variant = tknzr.nextToken();
            }
            this.locale = new Locale(language, country, variant);
        }
    }
}

