// configDlg.cpp : implementation file
//

#include "stdafx.h"
#include "config.h"
#include "configDlg.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

//////////////////     //////////////////
DWORD WINAPI HandleThreadRecv( LPVOID lparam )
{

	CConfigDlg *dlg	= (CConfigDlg *) lparam; //CWnd::FromHandle( HWND( lparam ) );
	HWND hWnd = dlg->m_hWnd;

	TRACE("Recv Thread ( from server ) start with %d port!\r\n", UDP_CLIENT_LOGIN_RECV_PORT );


	///@note     UPD  
	//@todo delete []server. žƴ, ޸  ϱ Ű澲δ.
	NLSocket *server	= new NLSocket();
	
	server->Create( AF_INET, SOCK_DGRAM, IPPROTO_UDP );
	server->Bind( UDP_CLIENT_LOGIN_RECV_PORT );
	server->ChkErr();

	fd_set ReadSet;
	sockaddr_in remote_addr;
	int nRecv, nCount, addr_len;
	
	char *pRecvBuffer;
	
	memset( &ReadSet, 0, sizeof( ReadSet ) );
	TRACE("%d", MAX_UDP_BUFFER );


	///@note  ͸ Ѵ.
	while ( 1 ) {
		FD_ZERO( &ReadSet );
		FD_SET( server->m_socket, &ReadSet );
		nCount = select( server->m_socket + 1, &ReadSet, NULL, NULL, NULL );
		if ( nCount == 0 )					{ /** timeout */ }
		else if ( nCount == SOCKET_ERROR )	{ /** error */ }
		if ( ! ( FD_ISSET( server->m_socket, &ReadSet ) ) ) {
			/** error:  б ȣ ߻,    server->m_socket  ƴϴ. */
			TRACE("ERROR: FD_ISSET()");
		}
		addr_len = sizeof ( remote_addr );

		///@todo must be delete[]'ed after process.
		pRecvBuffer = new char[MAX_UDP_BUFFER];
		memset( pRecvBuffer, 0, sizeof( pRecvBuffer ) );
		nRecv	= recvfrom( server->m_socket, pRecvBuffer, MAX_UDP_BUFFER,
			0, (sockaddr *)&remote_addr, &addr_len );

		if ( nRecv == SOCKET_ERROR || nRecv < PACKET_DATA_HEADER_SIZE ) {
			//  Ȳ
			server->ChkErr();
			TRACE("ERROR:: SOCKET_ERROR or may be ...");
		}

		PACKET_DATA *packet = (PACKET_DATA *) pRecvBuffer;

		// ޼ 
		::SendMessage( hWnd, WM_RECVFROMSVR, (WPARAM) pRecvBuffer, nRecv );
	}
	return 0;
}




/////////////////////////////////////////////////////////////////////////////
// CAboutDlg dialog used for App About

class CAboutDlg : public CDialog
{
public:
	CAboutDlg();

// Dialog Data
	//{{AFX_DATA(CAboutDlg)
	enum { IDD = IDD_ABOUTBOX };
	//}}AFX_DATA

	// ClassWizard generated virtual function overrides
	//{{AFX_VIRTUAL(CAboutDlg)
	protected:
	virtual void DoDataExchange(CDataExchange* pDX);    // DDX/DDV support
	//}}AFX_VIRTUAL

// Implementation
protected:
	//{{AFX_MSG(CAboutDlg)
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()
};

CAboutDlg::CAboutDlg() : CDialog(CAboutDlg::IDD)
{
	//{{AFX_DATA_INIT(CAboutDlg)
	//}}AFX_DATA_INIT
}

void CAboutDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CAboutDlg)
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CAboutDlg, CDialog)
	//{{AFX_MSG_MAP(CAboutDlg)
		// No message handlers
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CConfigDlg dialog

CConfigDlg::CConfigDlg(CWnd* pParent /*=NULL*/)
	: CDialog(CConfigDlg::IDD, pParent)
{
	//{{AFX_DATA_INIT(CConfigDlg)
	m_ID = _T("");
	m_PW = _T("");
	m_Port = _T("");
	m_IP = _T("");
	//}}AFX_DATA_INIT
	// Note that LoadIcon does not require a subsequent DestroyIcon in Win32
	m_hIcon = AfxGetApp()->LoadIcon(IDR_MAINFRAME);
}

void CConfigDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CConfigDlg)
	DDX_Control(pDX, IDC_LIST, m_cList);
	DDX_Text(pDX, IDC_ID, m_ID);
	DDX_Text(pDX, IDC_PW, m_PW);
	DDX_Text(pDX, IDC_PORT, m_Port);
	DDX_Text(pDX, IDC_IP, m_IP);
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CConfigDlg, CDialog)
	//{{AFX_MSG_MAP(CConfigDlg)
	ON_WM_SYSCOMMAND()
	ON_WM_PAINT()
	ON_WM_QUERYDRAGICON()
	ON_BN_CLICKED(IDC_ADD, OnAdd)
	ON_WM_SHOWWINDOW()
	ON_MESSAGE(WM_RECVFROMSVR, OnRecvFromServer)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CConfigDlg message handlers

BOOL CConfigDlg::OnInitDialog()
{
	CDialog::OnInitDialog();

	// Add "About..." menu item to system menu.

	// IDM_ABOUTBOX must be in the system command range.
	ASSERT((IDM_ABOUTBOX & 0xFFF0) == IDM_ABOUTBOX);
	ASSERT(IDM_ABOUTBOX < 0xF000);

	CMenu* pSysMenu = GetSystemMenu(FALSE);
	if (pSysMenu != NULL)
	{
		CString strAboutMenu;
		strAboutMenu.LoadString(IDS_ABOUTBOX);
		if (!strAboutMenu.IsEmpty())
		{
			pSysMenu->AppendMenu(MF_SEPARATOR);
			pSysMenu->AppendMenu(MF_STRING, IDM_ABOUTBOX, strAboutMenu);
		}
	}

	// Set the icon for this dialog.  The framework does this automatically
	//  when the application's main window is not a dialog
	SetIcon(m_hIcon, TRUE);			// Set big icon
	SetIcon(m_hIcon, FALSE);		// Set small icon
	
	// TODO: Add extra initialization here

	///  Ŷ ۽ 
	m_socket = new NLSocket();
	m_socket->Create( AF_INET, SOCK_DGRAM, IPPROTO_UDP );
	m_socket->ChkErr();

	
	//   Ŷ  
	//   ϰ  ־Ѵ.
	DWORD	m_thread_id;
	m_hThread = CreateThread(NULL, 0, HandleThreadRecv, this, 0, &m_thread_id);


	///@Ʈ 
	CRect rect;
	m_cList.SetExtendedStyle(LVS_EX_GRIDLINES | LVS_EX_FULLROWSELECT);
	m_cList.GetClientRect(&rect);
	int nColInterval = rect.Width()/11;

	m_cList.InsertColumn(0, _T("ּ"), LVCFMT_LEFT, nColInterval *6);
	m_cList.InsertColumn(1, _T("Ʈ"), LVCFMT_LEFT, nColInterval  *1);
	m_cList.InsertColumn(2, _T("̵"), LVCFMT_LEFT, nColInterval  *2);
	m_cList.InsertColumn(3, _T(""), LVCFMT_LEFT, nColInterval  *2);

	LoadLoginList();


	m_Port.Format("%d", UDP_SERVER_RECV_PORT);
	UpdateData( FALSE );
	return TRUE;
}


void CConfigDlg::OnSysCommand(UINT nID, LPARAM lParam)
{
	if ((nID & 0xFFF0) == IDM_ABOUTBOX)
	{
		CAboutDlg dlgAbout;
		dlgAbout.DoModal();
	}
	else
	{
		CDialog::OnSysCommand(nID, lParam);
	}
}

// If you add a minimize button to your dialog, you will need the code below
//  to draw the icon.  For MFC applications using the document/view model,
//  this is automatically done for you by the framework.

void CConfigDlg::OnPaint() 
{
	if (IsIconic())
	{
		CPaintDC dc(this); // device context for painting

		SendMessage(WM_ICONERASEBKGND, (WPARAM) dc.GetSafeHdc(), 0);

		// Center icon in client rectangle
		int cxIcon = GetSystemMetrics(SM_CXICON);
		int cyIcon = GetSystemMetrics(SM_CYICON);
		CRect rect;
		GetClientRect(&rect);
		int x = (rect.Width() - cxIcon + 1) / 2;
		int y = (rect.Height() - cyIcon + 1) / 2;

		// Draw the icon
		dc.DrawIcon(x, y, m_hIcon);
	}
	else
	{
		CDialog::OnPaint();
	}
}

// The system calls this to obtain the cursor to display while the user drags
//  the minimized window.
HCURSOR CConfigDlg::OnQueryDragIcon()
{
	return (HCURSOR) m_hIcon;
}

BOOL CConfigDlg::PreTranslateMessage(MSG* pMsg) 
{
	// TODO: Add your specialized code here and/or call the base class
	if(pMsg->message == WM_KEYDOWN && (pMsg->wParam == VK_ESCAPE || pMsg->wParam == VK_RETURN )) return TRUE;
	return CDialog::PreTranslateMessage(pMsg);
}

void CConfigDlg::LoadLoginList()
{

	LVITEM lvi;

	///@note ̰  ȵȴ... ̷?
	m_cList.InsertItem( 1, "" );

	CString strItem;

	db.connect( PATH_DB );
	db.query( "SELECT * FROM config_login" );
	int i = 0;
	while ( db.next() ) {
		i++;

		//
		lvi.mask =  LVIF_TEXT;
		lvi.iItem = i;
		lvi.iSubItem = 0;
		lvi.pszText = (LPTSTR)(LPCTSTR) db.field("server_ip");
		m_cList.InsertItem(&lvi);

		//
		lvi.iSubItem =1;
		lvi.pszText = (LPTSTR)(LPCTSTR) db.field("server_port");
		m_cList.SetItem(&lvi);
		//
		lvi.iSubItem =2;
		lvi.pszText = (LPTSTR)(LPCTSTR) db.field("user_id");
		m_cList.SetItem(&lvi);

		//
		lvi.iSubItem =3;
		lvi.pszText = (LPTSTR)(LPCTSTR) "Unknown";
		m_cList.SetItem(&lvi);

		TRACE("%s:%s,%s\r\n", db.field("server_ip"), db.field("server_port"), db.field("user_id"));

	}
	db.close();
}



///@todo	̵/йȣ, ڵα ɼǿ  ϰ   ֵ ؾѴ.
///  ׳  . ڵα .
void CConfigDlg::OnAdd() 
{
	// TODO: Add your control notification handler code here
	UpdateData();

	db.connect( PATH_DB );
	int rc = db.query( "INSERT INTO config_login (user_id, user_pw, server_ip, server_port ) VALUES ('%s', '%s', '%s', '%s')",
		m_ID, m_PW, m_IP, m_Port );
	if ( rc != SQLITE_OK ) {
		switch ( rc ) {
		case SQLITE_CONSTRAINT :
			AfxMessageBox("̹   Ʈ մϴ.");
			break;
		default:
			AfxMessageBox("߰ ߽ϴ.");
		break;
		}
	}

	db.close();
}

void CConfigDlg::OnShowWindow(BOOL bShow, UINT nStatus) 
{
	CDialog::OnShowWindow(bShow, nStatus);
	
	// TODO: Add your message handler code here

	
	///@note ִ  ã´.
	FindAliveServers();

	// ׽Ʈ ̸ ٷ Ѵ.
	return;



	if ( __argv[1] == NULL ) {
		AfxMessageBox("޽ Ŭ̾Ʈ  α׷κ  ڵ  ߽ϴ.");
		DestroyWindow();
		return ;
	}
	HWND hMain = (HWND) atol( __argv[1] );
	::SendMessage( hMain, WM_IPC_LOGIN, ipc::RUNNING, (LPARAM) m_hWnd );
}

void CConfigDlg::FindAliveServers()
{
	int port;
	char ip[16];
	
	PACKET_DATA p;
	p.command			= packetcommand::HELLO;
	p.returnport		= UDP_CLIENT_LOGIN_RECV_PORT;

	db.connect( PATH_DB );
	char *q = "SELECT * FROM config_login";
	db.query( q );

	while ( db.next() ) {
		strcpy( ip, db.field("server_ip") );
		port = atoi( db.field("server_port") );
		if ( port == 0 ) port = UDP_SERVER_RECV_PORT;
		p.clivar	= inet_addr( ip );
		m_socket->SendTo( m_socket->m_socket, &p, PACKET_DATA_HEADER_SIZE, ip, port );
		TRACE("%s  HELLO Ŷ \r\n", ip);
	}
	db.close();
}

LONG CConfigDlg::OnRecvFromServer(WPARAM wParam, LPARAM lParam)
{
	UpdateData();
	

	LPVOID	lp	= (LPVOID) wParam;
	int		len	= (int) lParam;
	
	PACKET	packet;
	PACKET_DATA_MSGTOALL d;
	CString m;
	

	memcpy( &packet, lp, len );

	if ( packet.resultcode == packetrc::OK ) {
		// û .
		switch ( packet.command )
		{
		case packetcommand::HELLO		:
			sockaddr_in a;
			a.sin_addr.S_un.S_addr = packet.clivar;
			SetServerAlive( inet_ntoa( a.sin_addr ) );

			break;
		case packetcommand::LOGIN		:
			//m_UserUniqNo = packet.useruniqno;
			break;
		default							:
			TRACE("Ȯε ʴ    Ǿϴ.");
			break;
		}

		UpdateData(FALSE);
		
		delete []lp;
		lp = NULL;

		return 0L;
	}


	CString errstr;
	switch ( packet.resultcode )
	{
	case packetrc::NO_USER		:
		errstr = "̵ Ʋϴ, Ǵ  ̵ ڸ ã  ϴ.";
		break;
	case packetrc::INVALID_PW		:
		errstr = "йȣ Ʋϴ.";
		break;
	case packetrc::INVALID_DATA	:
		errstr = "û Ŷ  κ ߸Ǿϴ.";
		break;
	case packetrc::USER_ID_EXIST		:
		errstr = " ̵ ڰ մϴ.";
		break;
	case packetrc::DATABASE_IO_ERROR	:
		errstr = " ͺ̽ ó  ߻߽ϴ.";
		break;
	default			:
		errstr.Format("[%d]       ڵ带 ޾ҽϴ.", packet.resultcode );
		break;
	}

	TRACE("%s\r\n", errstr);
	UpdateData(FALSE);

	delete []lp;
	lp = NULL;
	return 0L;
}



///@note IP   ִ üũѴ.
///@note Ʈȣ üũ  ֵ ؾѴ.  Ʈȣ  ʴµ,
///		޼  , PACKET.clivar  Ʈ ȣ  ־ ༭ ؾ  .
void CConfigDlg::SetServerAlive( const char *ip )
{
	int n = m_cList.GetNextItem( -1, LVNI_ALL );
	
	TCHAR szBuffer[1024];
	DWORD cchBuf(1024);
	while ( n != -1 ) {
		LVITEM lvi;
		lvi.iItem = n;
		lvi.iSubItem = 0;
		lvi.mask = LVIF_TEXT;
		lvi.pszText = szBuffer;
		lvi.cchTextMax = cchBuf;
		m_cList.GetItem(&lvi);
		if ( strcmp( lvi.pszText, ip ) == 0 ) {
			//
			lvi.mask		=  LVIF_TEXT;
			lvi.iItem		= n;
			lvi.iSubItem	= 3;
			lvi.pszText = (LPTSTR)(LPCTSTR) "is Alive!";
			m_cList.SetItem(&lvi);
			return;
		}
		n = m_cList.GetNextItem( n, LVNI_ALL );
	}

}
