/**
@note	ws2_32.lib is needed on VS
@note	select() Լ ý ڿ  ũ ޴´.
		 ,   1024  ...  ý  Ʋ.
		  Լ IOCP  KQueue  ؼ  ȿ̴.
@note	÷ ũν Ͽ Ʈŷ ʿ  .
		  Segmentaion falut ̴.
		׷  Ŭ ̺귯  ʰ Ǯ ذ ߴ.
		 NLSocket Ŭ  ִٰ ϰ  ʴ.
		 NLSocket Ŭ  Ŭ̾Ʈ   ̴.
*/

#ifndef _WIN32
#include <netdb.h>		// for gethostbyname()
#include <errno.h>
#endif


#include "stdafx.h"		// include empty header file for precomplied header directive in MFC.
#include "nlibrary.h"


///@todo	ʱȭ ȭ 
NLSocket::NLSocket()
{
	m_socket	= INVALID_SOCKET;
//	memset( &client, 0, sizeof ( client ) ); ///@todo check

}

//
///@note Clean() Լ α׷   ȣؾѴ. ⼭ ȣϸ ȵȴ.
NLSocket::~NLSocket()
{
	Close();
}




/**
	 ϱ  ̺귯(DLL ε ) ʱȭѴ.
@note н ȯ濡  ۾ ʿ .

@return same as WSAStartup
*/
int NLSocket::Init()
{
#ifdef _WIN32
	/// ι  ʵ Ѵ.
	static BOOL bDone = false;
	if ( bDone ) return true;

	WORD	wVersionRequested;
	WSADATA	wsaData;
	int		nError;

	wVersionRequested	= MAKEWORD( 2, 2 );
	nError				= WSAStartup( wVersionRequested, &wsaData );

	if ( nError ) {
		// error
	}

	bDone = true;
	return nError;
#else
	return 0;
#endif

}


/*
	 ȯ濡 ȣѴ.

@note	 Լ  ̺귯 ü ϹǷ,
		Ŭ̾Ʈ  ϳ ݾҴٰ ؼ  Լ ȣϸ ȵȴ.
		׸  Լ Ư ü ѹ ȣϸȴ.
@return	same as WSACleanup
*/
int NLSocket::Clean()
{
	int rc;
#ifdef _WIN32
	rc	= WSACleanup();
#else
	rc	= 0;
#endif
	return rc;
}



///@return  ũ
int NLSocket::Create( int af, int type, int protocol )
{
#ifdef _WIN32
	Init();
#endif

	m_socket	= socket( af, type, protocol );
	return m_socket;
}

///@todo IP-Address  ޾Ƽ ε   ֵ
///@return same as bind()
/**
@example
	server = new NLSocket();
	server->Create( AF_INET, SOCK_STREAM, IPPROTO_TCP );
	server->Bind( TCP_SERVER_RECV_PORT );
	server->Listen( 100 );

	
	while ( 1 ) {
		client = new NLSocket();
		SOCKET socket = server->Accept( );
		if ( socket == INVALID_SOCKET )
			continue;
		....
	}
*/
int NLSocket::Bind( int port )
{
	addr.sin_family = AF_INET;
	addr.sin_port = htons(port);
	addr.sin_addr.s_addr = INADDR_ANY;
	memset( addr.sin_zero, 0, sizeof( addr ) );

	return bind( m_socket, (sockaddr *) &addr, sizeof ( addr ) );
}


int NLSocket::Listen( int pending )
{
	return listen( m_socket, pending );
}


/**
 * @return same as accept
 */
SOCKET NLSocket::Accept( )
{
//	int addr_len;
//	memset( &client, 0, sizeof ( client ) );
	return accept( m_socket, 0, 0 );//(struct sockaddr *)&client, (socklen_t *)&addr_len);
}



/**
@note	  Ѵ.
@return same as connect
@example
	NLSocket *sock = new NLSocket( );
	sock->Create( AF_INET, SOCK_STREAM, IPPROTO_TCP );
	sock->Connect( m_IP, UDP_SERVER_RECV_PORT );
	PACKET packet, recvpack;
	packet.command		= packetcommand::HELLO;
	packet.returnaddr	= m_addr_local.sin_addr.s_addr;
	packet.returnport	= UDP_CLIENT_RECV_PORT;
	sock->Send( (char *) &packet, PACKET_HEADER_SIZE );
	sock->ChkErr();
	int nRecv=0;
	sock->Recv( (char *)&recvpack, PACKET_SIZE, &nRecv );
	sock->Close();
*/
int NLSocket::Connect( const char *ip, unsigned short port )
{
	sockaddr_in addr;
	addr.sin_family			= AF_INET;
	addr.sin_addr.s_addr	= inet_addr( ip );
	addr.sin_port			= htons( port );
	return connect( m_socket, (sockaddr *)&addr, sizeof( addr ) );
}


/**
 *   ܺο   Ѵ.
 * , Attach   ȿ ̾ϸ,
 * Attach Ǵ ü   Ǿ ־Ѵ.
 * @return ̸ 0, ƴϸ 1
 */
BOOL	NLSocket::Attach( SOCKET new_socket )
{
	if ( new_socket == INVALID_SOCKET )
		return true;

	m_socket	= new_socket;
	return false;
}




/**
 *   Ѵ.
 *       ְ    ִ.
 *   , ǥ  Ʈ  ޼ ǥѴ.
 * @return   false,   true
 * @ex SOCKET socket = server->Accept( ); server->ChkErr();
 */
BOOL	NLSocket::ChkErr()
{
	char *msg="˼ ";
	int nError=0;
#ifdef _WIN32
	nError	= WSAGetLastError();

	if ( nError == 0 ) return false;
	switch ( nError )
	{
	case WSANOTINITIALISED	:
		msg = "WSAStartup Լ ȣ ʾҽϴ.";
		break;
	case WSAENETDOWN		:
		msg = "Ʈũ ٿ";
		break;
	case WSAEFAULT			:
		msg = "addrlen ڰ ";
		break;
	case WSAEINTR			:
		msg = "ƮƮ  ߴ";
		break;
	case WSAEINPROGRESS		:
		msg = "ŷ   1.1   ̰ų    ڰ ݹ Լ ó";
		break;

	case WSAEINVAL			:
		msg = "accept()  listen()  ";
		break;
	case WSAEISCONN			:
		msg = "  Դϴ.  Ǵ ޼ ݿ   Լ  Ͽ   ϴ.";
		break;
	case WSAENETRESET		:
		msg = "Ʈũ  缳Ǿϴ. ش ۾ Ǵ   ߻Ͽ  ϴ.";
		break;

	case WSAENOTSOCK		:
		msg = " ĺڰ ƴմϴ.";
		break;
	case WSAEMFILE			:
		msg = "  ť   ,   ִ  ĺڰ ";
		break;
	case WSAENOBUFS			:
		msg = " ";
		break;
	case WSAEOPNOTSUPP		:
		msg = "Ǵ   񽺸 ϴ  ƴ";
		break;
	case WSAEWOULDBLOCK		:
		msg = " ͺŷ   ε, ť ޾Ƶ   ʽϴ.";
		break;
	case WSAEMSGSIZE		:
		msg = "޽  ۺ ũ⶧ ʰиŭ ߷Ƚϴ.";
		break;
	case WSAETIMEDOUT		:
		msg = "Ʈũ  Ǵ Ǿ ý  ʾұ⶧  ϴ.";
		break;
	case WSAECONNRESET		:
		msg = " ǻ      ȸ  Ǿϴ.";
		break;
	case WSAEADDRNOTAVAIL	:
		msg = " ּҰ ȿ ʽϴ. , INADDR_ANY    ߽ϴ.";
		break;
	case 10057 :
		msg = "  ʾҽϴ.";
		break;
	}


	WSASetLastError( 0 );
#else

	nError = errno;

	switch ( nError )
	{
	case EWOULDBLOCK	:
		msg = "The  socket  is  marked non-blocking and no connec tions are present to be accepted. ";
		break;
	case EBADF		:
		msg = "The descriptor is invalid.";
		break;
	case ENOTSOCK		:
		msg = "The descriptor references a file, not a socket.";
		break;
	case EOPNOTSUPP		:
		msg = "The referenced socket is not of type SOCK_STREAM.";
		break;
	case EFAULT		:
		msg = "The addr parameter is not in a writable part of the user address space.";
		break;
	case EPERM		:
		msg = "Firewall rules forbid connection.";
		break;
	case ENOBUFS		:
	case ENOMEM		:
		msg = "Not  enough free memory.  This often means that the memory allocation is limited by the  socket  buffer limits, not by the system memory.";
		break;
	}
	errno=0;
	
#endif


#ifdef _WINDOWS
	if ( nError )
		TRACE("[%d] %s\n", nError, msg);
#else
	if ( nError )
		fprintf( stderr, "[%d] %s\n", nError, msg );
#endif
	msg = NULL;
	return false;
}



/**

  ͸ о δ.

  @param char *buf
	޸ ͸ ޾Ƽ  Ϳ ͸ Ѵ.

  @param int len
	͸ о  .   ۾ƾѴ.

  @param int *received
      ̸ Ѵ.
	NULL  ԷµǸ    ʴ´.
	, ׷ Ǹ ۽  Ḧ   .

  @note   NULL ڸ ߰ ʴ´.
  @note ͸  ϰ, ۽  , *received  0 ȴ.
	, ͸  ߰,  ߴ ˷,   NULL  Էؼ ȵȴ.
	  Ű  Ḧ  ٸ üũ   ׷ ص ȴ.
  @return ̸ 0, ƴϸ 0 ƴ 

*/
int		NLSocket::Recv( char *buf, int len, int *received )
{

	int nBytes;
	nBytes = recv( m_socket, buf, len, 0 );
	if ( nBytes == SOCKET_ERROR ) {
		return nBytes;	// SOCKET_ERROR  
	}
	else if ( nBytes == 0 ) {
		//  
		return CONNECTION_CLOSED;
	}

	*received = nBytes;
	return 0;
}

///@return same as send
int		NLSocket::Send( char *buf, int len )
{
	return send( m_socket, buf, len, 0 );
}


int		NLSocket::Close()
{
	if ( m_socket != INVALID_SOCKET) {
#ifdef _WIN32
		closesocket( m_socket );
#else
		close( m_socket );
#endif
		m_socket = INVALID_SOCKET;
	}
	return 0;
}

/**
@param	SOCKET sock
	SOCK_DGRAM   ȿ (SOCK_DGRAM).
	   Ŭ̾Ʈ ͸   ״ ̿ؼ
	Ŭ̾Ʈ    ִ. , SOCK_DGRAM  ,   ʿ䰡 .
@return same as send to
*/
int		NLSocket::SendTo( SOCKET sock, const void *msg, size_t len, const char *ip,  int port)
{
	sockaddr_in addr;
	addr.sin_family			= AF_INET;
	addr.sin_addr.s_addr	= inet_addr( ip );
	addr.sin_port			= htons( port );
	return sendto ( sock, (const char *) msg, len, 0, (sockaddr *) &addr, sizeof ( addr ) );
}
/**
@note SendTo() Լ ϴ. ٸ ip ּҰ
	Ʈũ Ʈ   unsigned long	  ;Ѵ.
*/
int		NLSocket::SendTo( SOCKET sock, const void *msg, size_t len, unsigned long ip,  int port)
{
	sockaddr_in addr;
	addr.sin_family			= AF_INET;
	addr.sin_addr.s_addr	= ip;
	addr.sin_port			= htons( port );
	return sendto ( sock, (const char *) msg, len, 0, (sockaddr *) &addr, sizeof ( addr ) );
}



/**
   Ŭ   Լ ̿  ִ.
@todo	 ε   ϴ Į IP  ϰ ߾Ѵ.
@note	  ʱȭ ؾ߰  .
@note	н ýۿ  ̸ /etc/hosts  ˸ IP  ϵǾ ִ° .
@return  ǻ    ִ in_addr
*/
in_addr NLSocket::GetLocalAddr()
{
	char pHostName[64];
	gethostname( pHostName, sizeof( pHostName ) );
#ifndef _WIN32
	struct
#endif 
	hostent *pHostent = gethostbyname( pHostName );
	sockaddr_in local;
	memset( &local, 0, sizeof( local ) );
	memcpy( &local.sin_addr, pHostent->h_addr, sizeof( in_addr ) );
	return local.sin_addr;
}

