/**
@note  (ũν  ) ̺귯 Ǯ ڵ. ξ    .
*/
#include "packet_read.h"
#include "time_library.h"

#include <queue>
using namespace std;


extern deque<PACKET> qWork;
extern MUTEX mu_work;



/**
	RunThreadPacketRead
*/
#ifdef _WIN32
DWORD WINAPI
#else
void *
#endif
	HandleThreadPacketRead(
#ifdef _WIN32
	LPVOID lParam
#else
	void *arg
#endif
	)
{

	///@note ۷ ͸ ؼ Ŷ  ִµ, Ŷ ٷ  .

	int _socket;
	int addr_len, received;

	struct sockaddr_in addr_local;
	struct sockaddr_in addr_remote;
	
	char buf[MAX_UDP_BUFFER];
	if((_socket=socket(AF_INET, SOCK_DGRAM,0)) == -1)
	{
		_print_errcode();
		_milisleep( 1000 );
		exit(1);
	}

	addr_local.sin_family = AF_INET;
	addr_local.sin_port = htons(UDP_SERVER_RECV_PORT);
	addr_local.sin_addr.s_addr = INADDR_ANY;
#ifdef _WIN32
	ZeroMemory( &(addr_local.sin_zero), 8 );
#else
	bzero(&(addr_local.sin_zero),8);
#endif
	printf("binding on packet_read\n");

	if(bind(_socket,(struct sockaddr*)&addr_local, sizeof(struct sockaddr))==-1){
		_print_errcode();
		_milisleep( 2000 );
		exit(1);
	}
	while ( 1 ) {
		memset(buf,'\0', MAX_UDP_BUFFER);
		printf("recvfrom on packet_read\n");
		addr_len = sizeof( addr_remote );
		if((received = recvfrom(_socket, buf, MAX_UDP_BUFFER,0 \
			, (struct sockaddr *)&addr_remote \
			,
#ifndef _WIN32
			 (socklen_t *)
#endif
			&addr_len)) == -1) {
			_print_errcode();
			_milisleep( 2000 );
			exit(1);
		}
		printf("recvfrom done! on packet_read\n");
		buf[received]='\0';
		printf("get packet form %s\n", inet_ntoa(addr_remote.sin_addr));
		printf("packet is %d bytes long\n", received);
		
		///   ۾ ť ߰
		PACKET packet;
		memcpy( &packet, buf, received );
		/// Ŷ  ּ
		packet.returnaddr = addr_remote.sin_addr.s_addr;



		MutexLock( &mu_work );
		qWork.push_back( packet );
		MutexUnlock( &mu_work );
		printf("packet.command=%d, ", packet.command);

	} // eo while
#ifdef _WIN32
	closesocket(_socket);
#else
	close(_socket);
#endif
	return NULL;
}




HANDLE_THREAD RunThreadPacketRead()
{
	HANDLE_THREAD	hThread;
#ifdef _WIN32
	DWORD	thread_id;
	hThread = CreateThread(NULL, 0, HandleThreadPacketRead, NULL, 0, &thread_id);
#else
	int thread_id;
	thread_id = pthread_create( &hThread, NULL, HandleThreadPacketRead, NULL );
#endif
	return hThread;
}


