
/**
@note	  , ؽ  ɾѴ.
@note	, ȸ ̵ Ұϴ.
		    ׼ ȸ ̵ йȣ 䱸Ѵ.
		ȸ ̵  ϰ ϰ ϵ · ,
		   ̵ ϸ ȵǰ ȸ ȣ ؾѴ.

		ȸ ȣ Ǿ ȵȴ.
		 ȸ   , REPLACE  ؼ ȵȴ.

*/
#include <time.h>
#include "main.h"
#include "nlibrary.h"
#include "thread_library.h"
#include "server_library.h"
#include "sqlite_library.h"

#ifdef _WIN32
# if (_MSC_VER > 1000)
#  pragma warning ( disable : 4355 4284  4231 4511 4512 4097 4786 4800 4018 4146 4244 4514 4127 4100 4663)
#  pragma warning ( disable : 4245 4514 4660) // conversion from enum to unsigned int signed/unsigned mismatch
#  if (_MSC_VER > 1200)
#   pragma warning ( disable : 4521 4522)
#  endif
# endif
#endif



#include <map>
#include <string>
using namespace std;

extern map<string, PING> mPing;	//  Ŭ̾Ʈ "IP:Ʈ" Ű   ִ.
//map<unsigned long, unsigned int>::iterator im;
extern MUTEX mu_ping;


template<typename MapType, typename KeyArgType, typename ValueArgType>
typename MapType::iterator _au(MapType& m, const KeyArgType& k, const ValueArgType& v)
{
	typename MapType::iterator lb = m.lower_bound(k);
	if ( lb != m.end() && !(m.key_comp()(k, lb->first)) ) {
		lb->second = lb->second + v;
		return lb;
	}
	else {
		typedef typename MapType::value_type MVT;
		return m.insert( lb, MVT( k, v ) );
	}
}






/**
	ͺ̽ üũ
@note	ͺ̽ ϴ, ùٸ  üũϰ ׷  ùٸѴ.
@todo	  Ȯ üũ ϰ, ʱȭ   ֵ .
@todo	üũ
*/
int _init_database( )
{
	// DB 
	CSQLite db;
	db.connect( PATH_DB );

	/// ƹ ̺̳ ϴ üũ
	char *q;
	q = "SELECT count(*) FROM sqlite_master WHERE type='table'";
	int cnt = atoi( db.result( q ) );
	if ( cnt != 0 ) {
		db.close();
		return 0;
	}

	///  ʴ´ٸ ϰ ʱȭ

	/// configuration TABLE
	q = "create table config (idx INTEGER PRIMARY KEY, key char(64), value char(255))";
	db.query( q );
	db.query( "create unique index config_key on config(key)" );

	/// user TABLE. sqlite  ʵ ̿   .
	q = "create table user " \
		"(idx INTEGER PRIMARY KEY, id char(64), pw char(64), name char(64), mail char(64))";
	db.query( q );
	db.query( "create unique index user_idx on user(idx)" );
	db.query( "create unique index user_id on user(id)" );

	db.close();


	return 0;
}



/**
@note	 α üũѴ.
@see	PROTOCOL.txt
@return	Է  Ŷ  ڵ带 ־ Ѵ.
*/
PACKET _user_login ( PACKET in )
{
	const char *idx;
	PACKET_DATA_LOGIN login;
	memcpy( &login, in.data, sizeof ( login ) );


	if ( login.id[0] == '\0' || login.pw[0] == '\0' ) {
		in.resultcode	= packetrc::INVALID_DATA;
		return in;
	}

	CSQLite db;
	db.connect( PATH_DB );
	idx = db.result("SELECT idx FROM user WHERE id='%s' AND pw='%s'", login.id, login.pw);
	if ( idx == NULL ) {
		idx = db.result("SELECT idx FROM user WHERE id='%s'", login.id);
		if ( idx == NULL )
			in.resultcode	= packetrc::NO_USER;
		else
			in.resultcode	= packetrc::INVALID_PW;
	}
	else {		
		in.resultcode	= packetrc::OK;
		in.useruniqno	= atoi( idx );
	}
	db.close();
	
	return in;
}



/**
@note	  óѴ.
@see	PROTOCOL.txt
@return	Է  Ŷ  ڵ带 ־ Ѵ.
@note	id, pw, name  ʼ̴.
*/
PACKET _user_signup( PACKET in )
{
	const char *idx = NULL;
	PACKET_DATA_SIGNUP s;
	memcpy( &s, in.data, sizeof( s ) );

	if ( s.id[0] == '\0' || s.pw[0] == '\0' || s.name[0] == '\0' ) {
		in.resultcode	= packetrc::INVALID_DATA;
		return in;
	}
	CSQLite db;
	db.connect( PATH_DB );
	// ̵  üũ
	idx = db.result("SELECT idx FROM user WHERE id='%s'", s.id);
	if ( idx != NULL ) {
		in.resultcode	= packetrc::USER_ID_EXIST;
		return in;
	}
	int rc = db.query( "INSERT INTO user ( id, pw, name, mail ) values " \
		"('%s', '%s', '%s', '%s')", s.id, s.pw, s.name, s.mail );
	if ( rc != SQLITE_OK ) {
		in.resultcode	= packetrc::DATABASE_IO_ERROR;
		return in;
	}
	in.resultcode	= packetrc::OK;
	return in;
}

PACKET _user_modify		( PACKET in )
{
	
	
	PACKET_DATA_USERMOD d;
	memcpy( &d, in.data, sizeof( d ) );

	if ( d.id[0] == '\0' || d.pw[0] == '\0' || d.name[0] == '\0' ) {
		in.resultcode	= packetrc::INVALID_DATA;
		return in;
	}

	const char *pw = NULL;
	CSQLite db;
	db.connect( PATH_DB );


	// ̵  & йȣ üũ
	pw = db.result("SELECT pw FROM user WHERE idx='%d' AND id='%s'", in.useruniqno, d.id);
	if ( pw == NULL ) {
		in.resultcode	= packetrc::NO_USER;
		return in;
	}

	// ̵ ϴµ йȣ Ʋ,
	if ( strcmp( pw, (const char *)d.pw ) ) {
		in.resultcode	= packetrc::INVALID_PW;
		return in;
	}

	// 

	if ( d.newpw[0] != '\0' )		// йȣ 
		memcpy( d.pw, d.newpw, sizeof( d.pw ) );


	int rc;

	//  ̵  Ұ
	rc = db.query( "UPDATE user SET pw='%s', name='%s', mail='%s' WHERE idx='%d'", \
		d.pw, d.name, d.mail, in.useruniqno );

	if ( rc != SQLITE_OK ) {
		in.resultcode	= packetrc::DATABASE_IO_ERROR;
		return in;
	}
	in.resultcode	= packetrc::OK;
	
	return in;
}



PACKET _user_unsign( PACKET in )
{
	PACKET_DATA_UNSIGN u;
	memcpy( &u, in.data, sizeof ( u ) );

	if ( u.id[0] == '\0' || u.pw[0] == '\0' ) {
		in.resultcode	= packetrc::INVALID_DATA;
		return in;
	}

	const char *pw;
	CSQLite db;
	db.connect( PATH_DB );
	// ̵ ϸ йȣ üũ
	pw = db.result("SELECT pw FROM user WHERE id='%s'", u.id);
	if ( pw == NULL ) {
		in.resultcode	= packetrc::NO_USER;
		return in;
	}
	// ̵ ϴµ йȣ Ʋ,
	if ( strcmp( pw, (const char *)u.pw ) ) {
		in.resultcode	= packetrc::INVALID_PW;
		return in;
	}

	// 
	int rc = db.query( "DELETE FROM user WHERE id='%s' AND pw='%s'", u.id, u.pw );
	if ( rc != SQLITE_OK ) {
		in.resultcode	= packetrc::DATABASE_IO_ERROR;
		return in;
	}

	in.resultcode	= packetrc::OK;
	return in;
}


/**
	IP  PING ð üũ Ÿ ۾ Ѵ.

@note	  ˻ؼ PING    ڸ  Ų.
@note	  UNIX TIMESTAMP ̴.
@note	Ű=>"IPPORT"  Ʈ
		6Ʈ ̻  ڷ     , ¿ .
		Ʈ ϸ  5  ڷ  .
@ntoe	=> PING TIMESTAMP, ȸ ̵    ü
*/
PACKET _ping ( PACKET in )
{

	
	string key;
	
	char ip[9]={0,}, port[6]={0,};
	sprintf( ip, "%x", in.returnaddr );
	sprintf( port, "%d", in.returnport );
	key	=	ip;
	key +=	port;

	PING value;
	value.stamp = _get_stamp();
	///@todo     ʴ´.
	/// Ƚ üũϱ ؼ   ī  оѴ.
	/// CPU   ʿ .
	//value.count ++;
	value.ip	= in.returnaddr;
	value.port	= in.returnport;

	MutexLock( &mu_ping );
	mPing.insert( pair<string, PING> ( key, value ) );
	MutexUnlock( &mu_ping );

	in.resultcode	= packetrc::OK;
	return in;
}
